/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class ResidentTaskCache {
    private static final Cache<Long, Long> cache = CacheBuilder.newBuilder().concurrencyLevel(8).expireAfterWrite(10L, TimeUnit.SECONDS).build();

    public static void refresh(Long jobId, Long nextTriggerTime) {
        cache.put((Object)jobId, (Object)nextTriggerTime);
    }

    public static Long getOrDefault(Long jobId, Long nextTriggerTime) {
        return Optional.ofNullable((Long)cache.getIfPresent((Object)jobId)).orElse(nextTriggerTime);
    }

    public static Long get(Long jobId) {
        return ResidentTaskCache.getOrDefault(jobId, null);
    }

    public static boolean isResident(Long jobId) {
        return cache.asMap().containsKey(jobId);
    }
}

