/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.dispatch;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.enums.MapReduceStageEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.JobTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.job.task.dto.TaskExecuteDTO;
import com.aizuda.snailjob.server.job.task.dto.WorkflowNodeTaskExecuteDTO;
import com.aizuda.snailjob.server.job.task.support.JobExecutor;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.alarm.event.JobTaskFailAlarmEvent;
import com.aizuda.snailjob.server.job.task.support.executor.job.JobExecutorContext;
import com.aizuda.snailjob.server.job.task.support.executor.job.JobExecutorFactory;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGenerateContext;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGenerator;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGeneratorFactory;
import com.aizuda.snailjob.server.job.task.support.handler.JobTaskBatchHandler;
import com.aizuda.snailjob.server.job.task.support.handler.WorkflowBatchHandler;
import com.aizuda.snailjob.server.job.task.support.timer.JobTimeoutCheckTask;
import com.aizuda.snailjob.server.job.task.support.timer.JobTimerWheel;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="JobExecutorActor")
@Scope(value="prototype")
public class JobExecutorActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobExecutorActor.class);
    private final JobMapper jobMapper;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final TransactionTemplate transactionTemplate;
    private final WorkflowBatchHandler workflowBatchHandler;
    private final JobTaskBatchHandler jobTaskBatchHandler;
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(TaskExecuteDTO.class, taskExecute -> {
            try {
                log.debug("\u51c6\u5907\u6267\u884c\u4efb\u52a1. [{}] [{}]", (Object)LocalDateTime.now(), (Object)JsonUtil.toJsonString((Object)taskExecute));
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult((TaskExecuteDTO)taskExecute){
                    final /* synthetic */ TaskExecuteDTO val$taskExecute;
                    {
                        this.val$taskExecute = taskExecuteDTO;
                    }

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        JobExecutorActor.this.doExecute(this.val$taskExecute);
                    }
                });
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("job executor exception. [{}]", new Object[]{taskExecute, e});
                this.handleTaskBatch((TaskExecuteDTO)taskExecute, JobTaskBatchStatusEnum.FAIL.getStatus(), JobOperationReasonEnum.TASK_EXECUTION_ERROR.getReason());
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(final TaskExecuteDTO taskExecute) {
        List<JobTask> taskList;
        int taskStatus;
        Job job;
        block13: {
            block12: {
                int operationReason;
                block11: {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    if (JobTaskExecutorSceneEnum.AUTO_JOB.getType().equals(taskExecute.getTaskExecutorScene())) {
                        queryWrapper.eq(Job::getJobStatus, (Object)StatusEnum.YES.getStatus());
                    }
                    job = (Job)this.jobMapper.selectOne((Wrapper)queryWrapper.eq(Job::getId, (Object)taskExecute.getJobId()));
                    taskStatus = JobTaskBatchStatusEnum.RUNNING.getStatus();
                    try {
                        operationReason = JobOperationReasonEnum.NONE.getReason();
                        if (Objects.isNull(job)) {
                            taskStatus = JobTaskBatchStatusEnum.CANCEL.getStatus();
                            operationReason = JobOperationReasonEnum.JOB_CLOSED.getReason();
                        } else if (CollUtil.isEmpty((Collection)CacheRegisterTable.getServerNodeSet((String)job.getGroupName(), (String)job.getNamespaceId()))) {
                            taskStatus = JobTaskBatchStatusEnum.CANCEL.getStatus();
                            operationReason = JobOperationReasonEnum.NOT_CLIENT.getReason();
                            WorkflowNodeTaskExecuteDTO taskExecuteDTO = new WorkflowNodeTaskExecuteDTO();
                            taskExecuteDTO.setWorkflowTaskBatchId(taskExecute.getWorkflowTaskBatchId());
                            taskExecuteDTO.setTaskExecutorScene(taskExecute.getTaskExecutorScene());
                            taskExecuteDTO.setParentId(taskExecute.getWorkflowNodeId());
                            taskExecuteDTO.setTaskBatchId(taskExecute.getTaskBatchId());
                            this.workflowBatchHandler.openNextNode(taskExecuteDTO);
                        }
                        if (!CollUtil.isEmpty((Collection)CacheRegisterTable.getServerNodeSet((String)job.getGroupName(), (String)job.getNamespaceId()))) break block11;
                        SnailSpringContext.getContext().publishEvent((ApplicationEvent)new JobTaskFailAlarmEvent(JobTaskFailAlarmEventDTO.builder().jobTaskBatchId(taskExecute.getTaskBatchId()).reason(JobNotifySceneEnum.JOB_NO_CLIENT_NODES_ERROR.getDesc()).notifyScene(JobNotifySceneEnum.JOB_NO_CLIENT_NODES_ERROR.getNotifyScene()).build()));
                    }
                    catch (Throwable throwable) {
                        log.debug("\u51c6\u5907\u6267\u884c\u4efb\u52a1\u5b8c\u6210.[{}]", (Object)JsonUtil.toJsonString((Object)taskExecute));
                        int finalTaskStatus = taskStatus;
                        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){
                            final /* synthetic */ TaskExecuteDTO val$taskExecute;
                            final /* synthetic */ int val$finalTaskStatus;
                            final /* synthetic */ Job val$job;
                            {
                                this.val$taskExecute = taskExecuteDTO;
                                this.val$finalTaskStatus = n;
                                this.val$job = job;
                            }

                            public void afterCompletion(int status) {
                                JobTimerWheel.clearCache(MessageFormat.format("job_{0}", this.val$taskExecute.getTaskBatchId()));
                                if (JobTaskBatchStatusEnum.RUNNING.getStatus() == this.val$finalTaskStatus) {
                                    JobTimerWheel.registerWithJob(() -> new JobTimeoutCheckTask(this.val$taskExecute.getTaskBatchId(), this.val$job.getId()), Duration.ofMillis(DateUtils.toEpochMilli((long)this.val$job.getExecutorTimeout().intValue()) + 500L));
                                }
                                JobExecutorActor.this.jobTaskBatchHandler.openResidentTask(this.val$job, this.val$taskExecute);
                            }
                        });
                        throw throwable;
                    }
                    log.debug("\u51c6\u5907\u6267\u884c\u4efb\u52a1\u5b8c\u6210.[{}]", (Object)JsonUtil.toJsonString((Object)taskExecute));
                    int finalTaskStatus = taskStatus;
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                this.handleTaskBatch(taskExecute, taskStatus, operationReason);
                if (taskStatus == JobTaskBatchStatusEnum.RUNNING.getStatus()) break block12;
                log.debug("\u51c6\u5907\u6267\u884c\u4efb\u52a1\u5b8c\u6210.[{}]", (Object)JsonUtil.toJsonString((Object)taskExecute));
                int finalTaskStatus = taskStatus;
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* invalid duplicate definition of identical inner class */);
                return;
            }
            JobTaskGenerator taskInstance = JobTaskGeneratorFactory.getTaskInstance(job.getTaskType());
            JobTaskGenerateContext instanceGenerateContext = JobTaskConverter.INSTANCE.toJobTaskInstanceGenerateContext(job);
            instanceGenerateContext.setTaskBatchId(taskExecute.getTaskBatchId());
            if (Objects.nonNull(taskExecute.getTmpArgsStr())) {
                instanceGenerateContext.setArgsStr(taskExecute.getTmpArgsStr());
            }
            if (Lists.newArrayList((Object[])new Integer[]{JobTaskTypeEnum.MAP_REDUCE.getType(), JobTaskTypeEnum.MAP.getType()}).contains(job.getTaskType())) {
                instanceGenerateContext.setTaskName("ROOT_MAP");
                instanceGenerateContext.setMapSubTask(Lists.newArrayList((Object[])new String[]{""}));
                instanceGenerateContext.setMrStage(MapReduceStageEnum.MAP.getStage());
            }
            if (!CollUtil.isEmpty(taskList = taskInstance.generate(instanceGenerateContext))) break block13;
            SnailJobLog.LOCAL.warn("Generate job task is empty, taskBatchId:[{}]", new Object[]{taskExecute.getTaskBatchId()});
            log.debug("\u51c6\u5907\u6267\u884c\u4efb\u52a1\u5b8c\u6210.[{}]", (Object)JsonUtil.toJsonString((Object)taskExecute));
            int finalTaskStatus = taskStatus;
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* invalid duplicate definition of identical inner class */);
            return;
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                WorkflowTaskBatch workflowTaskBatch = null;
                Long workflowTaskBatchId = taskExecute.getWorkflowTaskBatchId();
                if (Objects.nonNull(workflowTaskBatchId)) {
                    workflowTaskBatch = (WorkflowTaskBatch)JobExecutorActor.this.workflowTaskBatchMapper.selectOne((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{WorkflowTaskBatch::getWfContext}).eq(WorkflowTaskBatch::getId, (Object)taskExecute.getWorkflowTaskBatchId()));
                }
                JobExecutor jobExecutor = JobExecutorFactory.getJobExecutor(job.getTaskType());
                jobExecutor.execute(JobExecutorActor.buildJobExecutorContext(taskExecute, job, taskList, workflowTaskBatch));
            }
        });
        log.debug("\u51c6\u5907\u6267\u884c\u4efb\u52a1\u5b8c\u6210.[{}]", (Object)JsonUtil.toJsonString((Object)taskExecute));
        int finalTaskStatus = taskStatus;
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* invalid duplicate definition of identical inner class */);
    }

    @NotNull
    private static JobExecutorContext buildJobExecutorContext(TaskExecuteDTO taskExecute, Job job, List<JobTask> taskList, WorkflowTaskBatch workflowTaskBatch) {
        JobExecutorContext context = JobTaskConverter.INSTANCE.toJobExecutorContext(job);
        context.setTaskList(taskList);
        context.setTaskBatchId(taskExecute.getTaskBatchId());
        context.setJobId(job.getId());
        context.setWorkflowTaskBatchId(taskExecute.getWorkflowTaskBatchId());
        context.setWorkflowNodeId(taskExecute.getWorkflowNodeId());
        if (Objects.nonNull(workflowTaskBatch)) {
            context.setWfContext(workflowTaskBatch.getWfContext());
        }
        return context;
    }

    private void handleTaskBatch(TaskExecuteDTO taskExecute, int taskStatus, int operationReason) {
        JobTaskBatch jobTaskBatch = new JobTaskBatch();
        jobTaskBatch.setId(taskExecute.getTaskBatchId());
        jobTaskBatch.setExecutionAt(Long.valueOf(DateUtils.toNowMilli()));
        jobTaskBatch.setTaskBatchStatus(Integer.valueOf(taskStatus));
        jobTaskBatch.setOperationReason(Integer.valueOf(operationReason));
        Assert.isTrue((1 == this.jobTaskBatchMapper.updateById((Object)jobTaskBatch) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u4efb\u52a1\u5931\u8d25"));
        if (JobTaskBatchStatusEnum.NOT_SUCCESS.contains(taskStatus)) {
            SnailSpringContext.getContext().publishEvent((ApplicationEvent)new JobTaskFailAlarmEvent(JobTaskFailAlarmEventDTO.builder().jobTaskBatchId(taskExecute.getTaskBatchId()).reason(JobOperationReasonEnum.TASK_EXECUTION_ERROR.getDesc()).notifyScene(JobNotifySceneEnum.JOB_TASK_ERROR.getNotifyScene()).build()));
        }
    }

    @Generated
    public JobExecutorActor(JobMapper jobMapper, JobTaskBatchMapper jobTaskBatchMapper, TransactionTemplate transactionTemplate, WorkflowBatchHandler workflowBatchHandler, JobTaskBatchHandler jobTaskBatchHandler, WorkflowTaskBatchMapper workflowTaskBatchMapper) {
        this.jobMapper = jobMapper;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.transactionTemplate = transactionTemplate;
        this.workflowBatchHandler = workflowBatchHandler;
        this.jobTaskBatchHandler = jobTaskBatchHandler;
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
    }
}

