/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.dispatch;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.support.JobPrepareHandler;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="JobTaskPrepareActor")
@Scope(value="prototype")
public class JobTaskPrepareActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobTaskPrepareActor.class);
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final List<JobPrepareHandler> prepareHandlers;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(JobTaskPrepareDTO.class, job -> {
            try {
                this.doPrepare((JobTaskPrepareDTO)job);
            }
            catch (Exception e) {
                log.error("\u9884\u5904\u7406\u8282\u70b9\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private void doPrepare(JobTaskPrepareDTO prepare) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getJobId, (Object)prepare.getJobId())).in(JobTaskBatch::getTaskBatchStatus, (Collection)JobTaskBatchStatusEnum.NOT_COMPLETE);
        JobTaskExecutorSceneEnum jobTaskExecutorSceneEnum = JobTaskExecutorSceneEnum.get((Integer)prepare.getTaskExecutorScene());
        if (SyetemTaskTypeEnum.WORKFLOW.getType().equals(jobTaskExecutorSceneEnum.getSystemTaskType().getType())) {
            queryWrapper.eq(JobTaskBatch::getWorkflowNodeId, (Object)prepare.getWorkflowNodeId());
            queryWrapper.eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)prepare.getWorkflowTaskBatchId());
            queryWrapper.eq(JobTaskBatch::getSystemTaskType, (Object)SyetemTaskTypeEnum.WORKFLOW.getType());
        } else {
            queryWrapper.eq(JobTaskBatch::getSystemTaskType, (Object)SyetemTaskTypeEnum.JOB.getType());
        }
        List notCompleteJobTaskBatchList = this.jobTaskBatchMapper.selectList((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)notCompleteJobTaskBatchList)) {
            JobTaskBatch jobTaskBatch = new JobTaskBatch();
            jobTaskBatch.setTaskBatchStatus(Integer.valueOf(JobTaskBatchStatusEnum.SUCCESS.getStatus()));
            notCompleteJobTaskBatchList = Lists.newArrayList((Object[])new JobTaskBatch[]{jobTaskBatch});
        }
        boolean onlyTimeoutCheck = false;
        for (JobTaskBatch jobTaskBatch : notCompleteJobTaskBatchList) {
            prepare.setExecutionAt(jobTaskBatch.getExecutionAt());
            prepare.setTaskBatchId(jobTaskBatch.getId());
            prepare.setOnlyTimeoutCheck(onlyTimeoutCheck);
            for (JobPrepareHandler prepareHandler : this.prepareHandlers) {
                if (!prepareHandler.matches(jobTaskBatch.getTaskBatchStatus())) continue;
                prepareHandler.handle(prepare);
                break;
            }
            onlyTimeoutCheck = true;
        }
    }

    @Generated
    public JobTaskPrepareActor(JobTaskBatchMapper jobTaskBatchMapper, List<JobPrepareHandler> prepareHandlers) {
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.prepareHandlers = prepareHandlers;
    }
}

