/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.stop;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.job.task.dto.JobExecutorResultDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.JobTaskStopHandler;
import com.aizuda.snailjob.server.job.task.support.stop.JobTaskStopFactory;
import com.aizuda.snailjob.server.job.task.support.stop.TaskStopJobContext;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.Collection;
import java.util.List;
import org.apache.pekko.actor.ActorRef;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractJobTaskStopHandler
implements JobTaskStopHandler,
InitializingBean {
    @Autowired
    private JobTaskMapper jobTaskMapper;
    @Autowired
    private JobTaskBatchMapper jobTaskBatchMapper;

    protected abstract void doStop(TaskStopJobContext var1);

    @Override
    public void stop(TaskStopJobContext context) {
        List jobTasks;
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTask::getTaskBatchId, (Object)context.getTaskBatchId());
        if (!context.isForceStop()) {
            queryWrapper.in(JobTask::getTaskStatus, (Collection)JobTaskStatusEnum.NOT_COMPLETE);
        }
        if (CollUtil.isEmpty((Collection)(jobTasks = this.jobTaskMapper.selectList((Wrapper)queryWrapper)))) {
            JobTaskBatch jobTaskBatch = new JobTaskBatch();
            jobTaskBatch.setId(context.getTaskBatchId());
            jobTaskBatch.setTaskBatchStatus(Integer.valueOf(JobTaskBatchStatusEnum.STOP.getStatus()));
            jobTaskBatch.setOperationReason(context.getJobOperationReason());
            this.jobTaskBatchMapper.updateById((Object)jobTaskBatch);
            return;
        }
        context.setJobTasks(jobTasks);
        this.doStop(context);
        if (context.isNeedUpdateTaskStatus()) {
            for (JobTask jobTask : jobTasks) {
                if (jobTask.getTaskStatus().intValue() == JobTaskStatusEnum.SUCCESS.getStatus()) continue;
                JobExecutorResultDTO jobExecutorResultDTO = JobTaskConverter.INSTANCE.toJobExecutorResultDTO(jobTask);
                jobExecutorResultDTO.setTaskStatus(JobTaskStatusEnum.STOP.getStatus());
                jobExecutorResultDTO.setMessage("\u4efb\u52a1\u505c\u6b62\u6210\u529f");
                jobExecutorResultDTO.setJobOperationReason(context.getJobOperationReason());
                jobExecutorResultDTO.setTaskType(this.getTaskType().getType());
                jobExecutorResultDTO.setWorkflowNodeId(context.getWorkflowNodeId());
                jobExecutorResultDTO.setWorkflowTaskBatchId(context.getWorkflowTaskBatchId());
                ActorRef actorRef = ActorGenerator.jobTaskExecutorResultActor();
                actorRef.tell((Object)jobExecutorResultDTO, actorRef);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        JobTaskStopFactory.registerTaskStop(this.getTaskType(), this);
    }
}

