/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.timer;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.job.task.support.idempotent.TimerIdempotent;
import io.netty.util.HashedWheelTimer;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class JobTimerWheel {
    private static final int TICK_DURATION = 100;
    private static final String THREAD_NAME_PREFIX = "job-task-timer-wheel-";
    private static HashedWheelTimer timer = null;
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(32, 32, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("job-task-timer-wheel-"));
    private static final TimerIdempotent idempotent = new TimerIdempotent();

    public static synchronized void registerWithWorkflow(Supplier<TimerTask<String>> task, Duration delay) {
        TimerTask<String> timerTask = task.get();
        JobTimerWheel.register((String)timerTask.idempotentKey(), timerTask, delay);
    }

    public static synchronized void registerWithJob(Supplier<TimerTask<String>> task, Duration delay) {
        TimerTask<String> timerTask = task.get();
        JobTimerWheel.register((String)timerTask.idempotentKey(), timerTask, delay);
    }

    public static synchronized void register(String idempotentKey, TimerTask<String> task, Duration delay) {
        JobTimerWheel.register(idempotentKey, hashedWheelTimer -> {
            SnailJobLog.LOCAL.debug("\u52a0\u5165\u65f6\u95f4\u8f6e. delay:[{}ms] idempotentKey:[{}]", new Object[]{delay, idempotentKey});
            timer.newTimeout((io.netty.util.TimerTask)task, Math.max(delay.toMillis(), 0L), TimeUnit.MILLISECONDS);
        });
    }

    public static synchronized void register(String idempotentKey, Consumer<HashedWheelTimer> consumer) {
        if (!JobTimerWheel.isExisted(idempotentKey)) {
            try {
                consumer.accept(timer);
                idempotent.set(idempotentKey);
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("\u52a0\u5165\u65f6\u95f4\u8f6e\u5931\u8d25. uniqueId:[{}]", new Object[]{idempotentKey, e});
            }
        }
    }

    public static boolean isExisted(String idempotentKey) {
        return idempotent.isExist(idempotentKey);
    }

    public static void clearCache(String idempotentKey) {
        idempotent.clear(idempotentKey);
    }

    static {
        timer = new HashedWheelTimer((ThreadFactory)new CustomizableThreadFactory(THREAD_NAME_PREFIX), 100L, TimeUnit.MILLISECONDS, 512, true, -1L, (Executor)executor);
        timer.start();
    }
}

