package com.aizuda.snailjob.server.job.task.support;

import com.aizuda.snailjob.client.model.request.DispatchJobRequest;
import com.aizuda.snailjob.client.model.request.DispatchJobResultRequest;
import com.aizuda.snailjob.client.model.request.MapTaskRequest;
import com.aizuda.snailjob.server.common.dto.JobAlarmInfo;
import com.aizuda.snailjob.server.common.dto.JobLogDTO;
import com.aizuda.snailjob.server.common.dto.JobLogMetaDTO;
import com.aizuda.snailjob.server.job.task.dto.BaseDTO;
import com.aizuda.snailjob.server.job.task.dto.CompleteJobBatchDTO;
import com.aizuda.snailjob.server.job.task.dto.JobExecutorResultDTO;
import com.aizuda.snailjob.server.job.task.dto.JobPartitionTaskDTO;
import com.aizuda.snailjob.server.job.task.dto.JobTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.dto.RealJobExecutorDTO;
import com.aizuda.snailjob.server.job.task.dto.RealStopTaskInstanceDTO;
import com.aizuda.snailjob.server.job.task.dto.ReduceTaskDTO;
import com.aizuda.snailjob.server.job.task.support.block.job.BlockStrategyContext;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackContext;
import com.aizuda.snailjob.server.job.task.support.executor.job.JobExecutorContext;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.WorkflowExecutorContext;
import com.aizuda.snailjob.server.job.task.support.generator.batch.JobTaskBatchGeneratorContext;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGenerateContext;
import com.aizuda.snailjob.server.job.task.support.result.job.JobExecutorResultContext;
import com.aizuda.snailjob.server.job.task.support.stop.TaskStopJobContext;
import com.aizuda.snailjob.server.model.dto.LogTaskDTO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.log.JobLogMessageDO;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobLogMessage;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-05-17T02:10:32+0000",
    comments = "version: 1.5.3.Final, compiler: javac, environment: Java 17.0.15 (Eclipse Adoptium)"
)
public class JobTaskConverterImpl implements JobTaskConverter {

    @Override
    public JobTaskPrepareDTO toJobTaskPrepare(JobPartitionTaskDTO job) {
        if ( job == null ) {
            return null;
        }

        JobTaskPrepareDTO jobTaskPrepareDTO = new JobTaskPrepareDTO();

        jobTaskPrepareDTO.setJobId( job.getId() );
        jobTaskPrepareDTO.setNamespaceId( job.getNamespaceId() );
        jobTaskPrepareDTO.setGroupName( job.getGroupName() );
        jobTaskPrepareDTO.setNextTriggerAt( job.getNextTriggerAt() );
        jobTaskPrepareDTO.setBlockStrategy( job.getBlockStrategy() );
        jobTaskPrepareDTO.setTaskType( job.getTaskType() );
        jobTaskPrepareDTO.setExecutorTimeout( job.getExecutorTimeout() );

        return jobTaskPrepareDTO;
    }

    @Override
    public JobTaskPrepareDTO toJobTaskPrepare(Job job) {
        if ( job == null ) {
            return null;
        }

        JobTaskPrepareDTO jobTaskPrepareDTO = new JobTaskPrepareDTO();

        jobTaskPrepareDTO.setJobId( job.getId() );
        jobTaskPrepareDTO.setNamespaceId( job.getNamespaceId() );
        jobTaskPrepareDTO.setGroupName( job.getGroupName() );
        if ( job.getNextTriggerAt() != null ) {
            jobTaskPrepareDTO.setNextTriggerAt( job.getNextTriggerAt() );
        }
        jobTaskPrepareDTO.setBlockStrategy( job.getBlockStrategy() );
        jobTaskPrepareDTO.setTaskType( job.getTaskType() );
        jobTaskPrepareDTO.setExecutorTimeout( job.getExecutorTimeout() );

        return jobTaskPrepareDTO;
    }

    @Override
    public JobTaskPrepareDTO toJobTaskPrepare(Job job, WorkflowExecutorContext context) {
        if ( job == null && context == null ) {
            return null;
        }

        JobTaskPrepareDTO jobTaskPrepareDTO = new JobTaskPrepareDTO();

        if ( job != null ) {
            jobTaskPrepareDTO.setJobId( job.getId() );
            jobTaskPrepareDTO.setNamespaceId( job.getNamespaceId() );
            jobTaskPrepareDTO.setGroupName( job.getGroupName() );
            if ( job.getNextTriggerAt() != null ) {
                jobTaskPrepareDTO.setNextTriggerAt( job.getNextTriggerAt() );
            }
            jobTaskPrepareDTO.setBlockStrategy( job.getBlockStrategy() );
            jobTaskPrepareDTO.setTaskType( job.getTaskType() );
            jobTaskPrepareDTO.setExecutorTimeout( job.getExecutorTimeout() );
        }
        if ( context != null ) {
            jobTaskPrepareDTO.setTaskBatchId( context.getTaskBatchId() );
            jobTaskPrepareDTO.setTaskExecutorScene( context.getTaskExecutorScene() );
            jobTaskPrepareDTO.setWorkflowTaskBatchId( context.getWorkflowTaskBatchId() );
            jobTaskPrepareDTO.setWorkflowNodeId( context.getWorkflowNodeId() );
            jobTaskPrepareDTO.setParentWorkflowNodeId( context.getParentWorkflowNodeId() );
        }

        return jobTaskPrepareDTO;
    }

    @Override
    public JobTaskBatchGeneratorContext toJobTaskGeneratorContext(JobTaskPrepareDTO jobTaskPrepareDTO) {
        if ( jobTaskPrepareDTO == null ) {
            return null;
        }

        JobTaskBatchGeneratorContext jobTaskBatchGeneratorContext = new JobTaskBatchGeneratorContext();

        jobTaskBatchGeneratorContext.setNamespaceId( jobTaskPrepareDTO.getNamespaceId() );
        jobTaskBatchGeneratorContext.setGroupName( jobTaskPrepareDTO.getGroupName() );
        jobTaskBatchGeneratorContext.setJobId( jobTaskPrepareDTO.getJobId() );
        jobTaskBatchGeneratorContext.setNextTriggerAt( jobTaskPrepareDTO.getNextTriggerAt() );
        jobTaskBatchGeneratorContext.setTaskExecutorScene( jobTaskPrepareDTO.getTaskExecutorScene() );
        jobTaskBatchGeneratorContext.setWorkflowTaskBatchId( jobTaskPrepareDTO.getWorkflowTaskBatchId() );
        jobTaskBatchGeneratorContext.setWorkflowNodeId( jobTaskPrepareDTO.getWorkflowNodeId() );
        jobTaskBatchGeneratorContext.setParentWorkflowNodeId( jobTaskPrepareDTO.getParentWorkflowNodeId() );
        jobTaskBatchGeneratorContext.setTmpArgsStr( jobTaskPrepareDTO.getTmpArgsStr() );

        return jobTaskBatchGeneratorContext;
    }

    @Override
    public JobTaskBatchGeneratorContext toJobTaskGeneratorContext(BlockStrategyContext context) {
        if ( context == null ) {
            return null;
        }

        JobTaskBatchGeneratorContext jobTaskBatchGeneratorContext = new JobTaskBatchGeneratorContext();

        jobTaskBatchGeneratorContext.setNamespaceId( context.getNamespaceId() );
        jobTaskBatchGeneratorContext.setGroupName( context.getGroupName() );
        jobTaskBatchGeneratorContext.setJobId( context.getJobId() );
        jobTaskBatchGeneratorContext.setNextTriggerAt( context.getNextTriggerAt() );
        jobTaskBatchGeneratorContext.setOperationReason( context.getOperationReason() );
        jobTaskBatchGeneratorContext.setTaskExecutorScene( context.getTaskExecutorScene() );
        jobTaskBatchGeneratorContext.setWorkflowTaskBatchId( context.getWorkflowTaskBatchId() );
        jobTaskBatchGeneratorContext.setWorkflowNodeId( context.getWorkflowNodeId() );
        jobTaskBatchGeneratorContext.setParentWorkflowNodeId( context.getParentWorkflowNodeId() );

        return jobTaskBatchGeneratorContext;
    }

    @Override
    public JobTaskGenerateContext toJobTaskInstanceGenerateContext(Job job) {
        if ( job == null ) {
            return null;
        }

        JobTaskGenerateContext jobTaskGenerateContext = new JobTaskGenerateContext();

        jobTaskGenerateContext.setJobId( job.getId() );
        jobTaskGenerateContext.setNamespaceId( job.getNamespaceId() );
        jobTaskGenerateContext.setGroupName( job.getGroupName() );
        jobTaskGenerateContext.setRouteKey( job.getRouteKey() );
        jobTaskGenerateContext.setArgsStr( job.getArgsStr() );
        jobTaskGenerateContext.setArgsType( job.getArgsType() );

        return jobTaskGenerateContext;
    }

    @Override
    public JobTaskGenerateContext toJobTaskInstanceGenerateContext(MapTaskRequest request) {
        if ( request == null ) {
            return null;
        }

        JobTaskGenerateContext jobTaskGenerateContext = new JobTaskGenerateContext();

        jobTaskGenerateContext.setTaskBatchId( request.getTaskBatchId() );
        jobTaskGenerateContext.setJobId( request.getJobId() );
        jobTaskGenerateContext.setTaskName( request.getTaskName() );
        jobTaskGenerateContext.setParentId( request.getParentId() );
        jobTaskGenerateContext.setWfContext( request.getWfContext() );

        return jobTaskGenerateContext;
    }

    @Override
    public JobTask toJobTaskInstance(JobTaskGenerateContext context) {
        if ( context == null ) {
            return null;
        }

        JobTask jobTask = new JobTask();

        jobTask.setNamespaceId( context.getNamespaceId() );
        jobTask.setGroupName( context.getGroupName() );
        jobTask.setTaskName( context.getTaskName() );
        jobTask.setJobId( context.getJobId() );
        jobTask.setTaskBatchId( context.getTaskBatchId() );
        jobTask.setParentId( context.getParentId() );
        jobTask.setArgsStr( context.getArgsStr() );
        jobTask.setArgsType( context.getArgsType() );
        jobTask.setMrStage( context.getMrStage() );
        jobTask.setWfContext( context.getWfContext() );

        return jobTask;
    }

    @Override
    public BlockStrategyContext toBlockStrategyContext(JobTaskPrepareDTO prepareDTO) {
        if ( prepareDTO == null ) {
            return null;
        }

        BlockStrategyContext blockStrategyContext = new BlockStrategyContext();

        blockStrategyContext.setJobId( prepareDTO.getJobId() );
        blockStrategyContext.setTaskBatchId( prepareDTO.getTaskBatchId() );
        blockStrategyContext.setNamespaceId( prepareDTO.getNamespaceId() );
        blockStrategyContext.setGroupName( prepareDTO.getGroupName() );
        blockStrategyContext.setTaskType( prepareDTO.getTaskType() );
        blockStrategyContext.setNextTriggerAt( prepareDTO.getNextTriggerAt() );
        blockStrategyContext.setTaskExecutorScene( prepareDTO.getTaskExecutorScene() );
        blockStrategyContext.setWorkflowTaskBatchId( prepareDTO.getWorkflowTaskBatchId() );
        blockStrategyContext.setWorkflowNodeId( prepareDTO.getWorkflowNodeId() );
        blockStrategyContext.setParentWorkflowNodeId( prepareDTO.getParentWorkflowNodeId() );

        return blockStrategyContext;
    }

    @Override
    public TaskStopJobContext toStopJobContext(BlockStrategyContext context) {
        if ( context == null ) {
            return null;
        }

        TaskStopJobContext taskStopJobContext = new TaskStopJobContext();

        taskStopJobContext.setNamespaceId( context.getNamespaceId() );
        taskStopJobContext.setGroupName( context.getGroupName() );
        taskStopJobContext.setJobId( context.getJobId() );
        taskStopJobContext.setTaskBatchId( context.getTaskBatchId() );
        taskStopJobContext.setTaskType( context.getTaskType() );
        taskStopJobContext.setWorkflowTaskBatchId( context.getWorkflowTaskBatchId() );
        taskStopJobContext.setWorkflowNodeId( context.getWorkflowNodeId() );

        return taskStopJobContext;
    }

    @Override
    public TaskStopJobContext toStopJobContext(JobExecutorResultContext context) {
        if ( context == null ) {
            return null;
        }

        TaskStopJobContext taskStopJobContext = new TaskStopJobContext();

        taskStopJobContext.setNamespaceId( context.getNamespaceId() );
        taskStopJobContext.setGroupName( context.getGroupName() );
        taskStopJobContext.setJobId( context.getJobId() );
        taskStopJobContext.setTaskBatchId( context.getTaskBatchId() );
        taskStopJobContext.setTaskType( context.getTaskType() );
        taskStopJobContext.setJobOperationReason( context.getJobOperationReason() );
        taskStopJobContext.setWorkflowTaskBatchId( context.getWorkflowTaskBatchId() );
        taskStopJobContext.setWorkflowNodeId( context.getWorkflowNodeId() );

        return taskStopJobContext;
    }

    @Override
    public TaskStopJobContext toStopJobContext(Job job) {
        if ( job == null ) {
            return null;
        }

        TaskStopJobContext taskStopJobContext = new TaskStopJobContext();

        taskStopJobContext.setJobId( job.getId() );
        taskStopJobContext.setNamespaceId( job.getNamespaceId() );
        taskStopJobContext.setGroupName( job.getGroupName() );
        taskStopJobContext.setTaskType( job.getTaskType() );

        return taskStopJobContext;
    }

    @Override
    public TaskStopJobContext toStopJobContext(JobTaskPrepareDTO context) {
        if ( context == null ) {
            return null;
        }

        TaskStopJobContext taskStopJobContext = new TaskStopJobContext();

        taskStopJobContext.setNamespaceId( context.getNamespaceId() );
        taskStopJobContext.setGroupName( context.getGroupName() );
        taskStopJobContext.setJobId( context.getJobId() );
        taskStopJobContext.setTaskBatchId( context.getTaskBatchId() );
        taskStopJobContext.setTaskType( context.getTaskType() );
        taskStopJobContext.setWorkflowTaskBatchId( context.getWorkflowTaskBatchId() );
        taskStopJobContext.setWorkflowNodeId( context.getWorkflowNodeId() );

        return taskStopJobContext;
    }

    @Override
    public JobLogMessageDO toJobLogMessage(JobLogDTO jobLogDTO) {
        if ( jobLogDTO == null ) {
            return null;
        }

        JobLogMessageDO jobLogMessageDO = new JobLogMessageDO();

        jobLogMessageDO.setNamespaceId( jobLogDTO.getNamespaceId() );
        jobLogMessageDO.setGroupName( jobLogDTO.getGroupName() );
        jobLogMessageDO.setJobId( jobLogDTO.getJobId() );
        jobLogMessageDO.setTaskBatchId( jobLogDTO.getTaskBatchId() );
        jobLogMessageDO.setTaskId( jobLogDTO.getTaskId() );
        jobLogMessageDO.setMessage( jobLogDTO.getMessage() );
        jobLogMessageDO.setRealTime( jobLogDTO.getRealTime() );

        return jobLogMessageDO;
    }

    @Override
    public JobLogMessageDO toJobLogMessage(LogTaskDTO logTaskDTO) {
        if ( logTaskDTO == null ) {
            return null;
        }

        JobLogMessageDO jobLogMessageDO = new JobLogMessageDO();

        jobLogMessageDO.setNamespaceId( logTaskDTO.getNamespaceId() );
        jobLogMessageDO.setGroupName( logTaskDTO.getGroupName() );
        jobLogMessageDO.setJobId( logTaskDTO.getJobId() );
        jobLogMessageDO.setTaskBatchId( logTaskDTO.getTaskBatchId() );
        jobLogMessageDO.setTaskId( logTaskDTO.getTaskId() );
        jobLogMessageDO.setRealTime( logTaskDTO.getRealTime() );

        return jobLogMessageDO;
    }

    @Override
    public JobLogMetaDTO toJobLogDTO(BaseDTO baseDTO) {
        if ( baseDTO == null ) {
            return null;
        }

        JobLogMetaDTO jobLogMetaDTO = new JobLogMetaDTO();

        jobLogMetaDTO.setNamespaceId( baseDTO.getNamespaceId() );
        jobLogMetaDTO.setGroupName( baseDTO.getGroupName() );
        jobLogMetaDTO.setJobId( baseDTO.getJobId() );
        jobLogMetaDTO.setTaskBatchId( baseDTO.getTaskBatchId() );
        jobLogMetaDTO.setTaskId( baseDTO.getTaskId() );

        return jobLogMetaDTO;
    }

    @Override
    public ClientCallbackContext toClientCallbackContext(DispatchJobResultRequest request) {
        if ( request == null ) {
            return null;
        }

        ClientCallbackContext clientCallbackContext = new ClientCallbackContext();

        if ( request.getRetryStatus() != null ) {
            clientCallbackContext.setRetryStatus( request.getRetryStatus() );
        }
        clientCallbackContext.setJobId( request.getJobId() );
        clientCallbackContext.setTaskBatchId( request.getTaskBatchId() );
        clientCallbackContext.setWorkflowTaskBatchId( request.getWorkflowTaskBatchId() );
        clientCallbackContext.setWorkflowNodeId( request.getWorkflowNodeId() );
        clientCallbackContext.setTaskId( request.getTaskId() );
        clientCallbackContext.setGroupName( request.getGroupName() );
        clientCallbackContext.setTaskStatus( request.getTaskStatus() );
        clientCallbackContext.setExecuteResult( request.getExecuteResult() );
        clientCallbackContext.setRetryScene( request.getRetryScene() );
        clientCallbackContext.setRetry( request.isRetry() );
        clientCallbackContext.setWfContext( request.getWfContext() );

        return clientCallbackContext;
    }

    @Override
    public ClientCallbackContext toClientCallbackContext(RealJobExecutorDTO request) {
        if ( request == null ) {
            return null;
        }

        ClientCallbackContext clientCallbackContext = new ClientCallbackContext();

        if ( request.getRetryStatus() != null ) {
            clientCallbackContext.setRetryStatus( request.getRetryStatus() );
        }
        clientCallbackContext.setJobId( request.getJobId() );
        clientCallbackContext.setNamespaceId( request.getNamespaceId() );
        clientCallbackContext.setTaskBatchId( request.getTaskBatchId() );
        clientCallbackContext.setWorkflowTaskBatchId( request.getWorkflowTaskBatchId() );
        clientCallbackContext.setWorkflowNodeId( request.getWorkflowNodeId() );
        clientCallbackContext.setTaskId( request.getTaskId() );
        clientCallbackContext.setGroupName( request.getGroupName() );
        clientCallbackContext.setRetryScene( request.getRetryScene() );
        clientCallbackContext.setWfContext( request.getWfContext() );

        return clientCallbackContext;
    }

    @Override
    public ClientCallbackContext toClientCallbackContext(Job job) {
        if ( job == null ) {
            return null;
        }

        ClientCallbackContext clientCallbackContext = new ClientCallbackContext();

        clientCallbackContext.setJobId( job.getId() );
        clientCallbackContext.setNamespaceId( job.getNamespaceId() );
        clientCallbackContext.setGroupName( job.getGroupName() );

        return clientCallbackContext;
    }

    @Override
    public DispatchJobRequest toDispatchJobRequest(RealJobExecutorDTO realJobExecutorDTO) {
        if ( realJobExecutorDTO == null ) {
            return null;
        }

        DispatchJobRequest dispatchJobRequest = new DispatchJobRequest();

        dispatchJobRequest.setNamespaceId( realJobExecutorDTO.getNamespaceId() );
        dispatchJobRequest.setJobId( realJobExecutorDTO.getJobId() );
        dispatchJobRequest.setTaskBatchId( realJobExecutorDTO.getTaskBatchId() );
        dispatchJobRequest.setTaskId( realJobExecutorDTO.getTaskId() );
        dispatchJobRequest.setTaskType( realJobExecutorDTO.getTaskType() );
        dispatchJobRequest.setGroupName( realJobExecutorDTO.getGroupName() );
        dispatchJobRequest.setParallelNum( realJobExecutorDTO.getParallelNum() );
        dispatchJobRequest.setExecutorType( realJobExecutorDTO.getExecutorType() );
        dispatchJobRequest.setExecutorInfo( realJobExecutorDTO.getExecutorInfo() );
        dispatchJobRequest.setExecutorTimeout( realJobExecutorDTO.getExecutorTimeout() );
        dispatchJobRequest.setTaskName( realJobExecutorDTO.getTaskName() );
        dispatchJobRequest.setMrStage( realJobExecutorDTO.getMrStage() );
        dispatchJobRequest.setArgsStr( realJobExecutorDTO.getArgsStr() );
        dispatchJobRequest.setShardingTotal( realJobExecutorDTO.getShardingTotal() );
        dispatchJobRequest.setShardingIndex( realJobExecutorDTO.getShardingIndex() );
        dispatchJobRequest.setWorkflowTaskBatchId( realJobExecutorDTO.getWorkflowTaskBatchId() );
        dispatchJobRequest.setWorkflowNodeId( realJobExecutorDTO.getWorkflowNodeId() );
        dispatchJobRequest.setRetryCount( realJobExecutorDTO.getRetryCount() );
        dispatchJobRequest.setRetryScene( realJobExecutorDTO.getRetryScene() );
        dispatchJobRequest.setRetryStatus( realJobExecutorDTO.getRetryStatus() );
        dispatchJobRequest.setWfContext( realJobExecutorDTO.getWfContext() );

        return dispatchJobRequest;
    }

    @Override
    public RealJobExecutorDTO toRealJobExecutorDTO(JobExecutorContext context, JobTask jobTask) {
        if ( context == null && jobTask == null ) {
            return null;
        }

        RealJobExecutorDTO realJobExecutorDTO = new RealJobExecutorDTO();

        if ( context != null ) {
            realJobExecutorDTO.setWfContext( context.getWfContext() );
            realJobExecutorDTO.setTaskType( context.getTaskType() );
            realJobExecutorDTO.setParallelNum( context.getParallelNum() );
            realJobExecutorDTO.setExecutorType( context.getExecutorType() );
            realJobExecutorDTO.setExecutorInfo( context.getExecutorInfo() );
            realJobExecutorDTO.setMaxRetryTimes( context.getMaxRetryTimes() );
            realJobExecutorDTO.setRetryInterval( context.getRetryInterval() );
            realJobExecutorDTO.setShardingTotal( context.getShardingTotal() );
            realJobExecutorDTO.setShardingIndex( context.getShardingIndex() );
            realJobExecutorDTO.setExecutorTimeout( context.getExecutorTimeout() );
            realJobExecutorDTO.setWorkflowTaskBatchId( context.getWorkflowTaskBatchId() );
            realJobExecutorDTO.setWorkflowNodeId( context.getWorkflowNodeId() );
        }
        if ( jobTask != null ) {
            realJobExecutorDTO.setGroupName( jobTask.getGroupName() );
            realJobExecutorDTO.setJobId( jobTask.getJobId() );
            realJobExecutorDTO.setTaskBatchId( jobTask.getTaskBatchId() );
            realJobExecutorDTO.setTaskId( jobTask.getId() );
            realJobExecutorDTO.setArgsStr( jobTask.getArgsStr() );
            if ( jobTask.getArgsType() != null ) {
                realJobExecutorDTO.setArgsType( String.valueOf( jobTask.getArgsType() ) );
            }
            realJobExecutorDTO.setExtAttrs( jobTask.getExtAttrs() );
            realJobExecutorDTO.setNamespaceId( jobTask.getNamespaceId() );
            realJobExecutorDTO.setTaskName( jobTask.getTaskName() );
            realJobExecutorDTO.setMrStage( jobTask.getMrStage() );
            realJobExecutorDTO.setRetryCount( jobTask.getRetryCount() );
        }

        return realJobExecutorDTO;
    }

    @Override
    public JobExecutorContext toJobExecutorContext(Job job) {
        if ( job == null ) {
            return null;
        }

        JobExecutorContext jobExecutorContext = new JobExecutorContext();

        jobExecutorContext.setJobId( job.getId() );
        jobExecutorContext.setNamespaceId( job.getNamespaceId() );
        jobExecutorContext.setGroupName( job.getGroupName() );
        jobExecutorContext.setTaskType( job.getTaskType() );
        jobExecutorContext.setArgsStr( job.getArgsStr() );
        jobExecutorContext.setArgsType( job.getArgsType() );
        jobExecutorContext.setRouteKey( job.getRouteKey() );
        jobExecutorContext.setExtAttrs( job.getExtAttrs() );
        jobExecutorContext.setParallelNum( job.getParallelNum() );
        jobExecutorContext.setExecutorType( job.getExecutorType() );
        jobExecutorContext.setExecutorInfo( job.getExecutorInfo() );
        jobExecutorContext.setMaxRetryTimes( job.getMaxRetryTimes() );
        jobExecutorContext.setRetryInterval( job.getRetryInterval() );
        jobExecutorContext.setExecutorTimeout( job.getExecutorTimeout() );

        return jobExecutorContext;
    }

    @Override
    public JobExecutorResultDTO toJobExecutorResultDTO(ClientCallbackContext context) {
        if ( context == null ) {
            return null;
        }

        JobExecutorResultDTO jobExecutorResultDTO = new JobExecutorResultDTO();

        jobExecutorResultDTO.setJobId( context.getJobId() );
        jobExecutorResultDTO.setTaskBatchId( context.getTaskBatchId() );
        jobExecutorResultDTO.setWorkflowTaskBatchId( context.getWorkflowTaskBatchId() );
        jobExecutorResultDTO.setWorkflowNodeId( context.getWorkflowNodeId() );
        jobExecutorResultDTO.setTaskId( context.getTaskId() );
        jobExecutorResultDTO.setNamespaceId( context.getNamespaceId() );
        jobExecutorResultDTO.setGroupName( context.getGroupName() );
        jobExecutorResultDTO.setTaskStatus( context.getTaskStatus() );
        jobExecutorResultDTO.setWfContext( context.getWfContext() );
        jobExecutorResultDTO.setRetryStatus( context.getRetryStatus() );

        return jobExecutorResultDTO;
    }

    @Override
    public JobExecutorResultDTO toJobExecutorResultDTO(JobTask jobTask) {
        if ( jobTask == null ) {
            return null;
        }

        JobExecutorResultDTO jobExecutorResultDTO = new JobExecutorResultDTO();

        jobExecutorResultDTO.setTaskId( jobTask.getId() );
        jobExecutorResultDTO.setJobId( jobTask.getJobId() );
        jobExecutorResultDTO.setTaskBatchId( jobTask.getTaskBatchId() );
        jobExecutorResultDTO.setNamespaceId( jobTask.getNamespaceId() );
        jobExecutorResultDTO.setGroupName( jobTask.getGroupName() );
        jobExecutorResultDTO.setTaskStatus( jobTask.getTaskStatus() );
        jobExecutorResultDTO.setWfContext( jobTask.getWfContext() );

        return jobExecutorResultDTO;
    }

    @Override
    public JobExecutorResultDTO toJobExecutorResultDTO(RealJobExecutorDTO realJobExecutorDTO) {
        if ( realJobExecutorDTO == null ) {
            return null;
        }

        JobExecutorResultDTO jobExecutorResultDTO = new JobExecutorResultDTO();

        jobExecutorResultDTO.setJobId( realJobExecutorDTO.getJobId() );
        jobExecutorResultDTO.setTaskBatchId( realJobExecutorDTO.getTaskBatchId() );
        jobExecutorResultDTO.setWorkflowTaskBatchId( realJobExecutorDTO.getWorkflowTaskBatchId() );
        jobExecutorResultDTO.setWorkflowNodeId( realJobExecutorDTO.getWorkflowNodeId() );
        jobExecutorResultDTO.setTaskId( realJobExecutorDTO.getTaskId() );
        jobExecutorResultDTO.setNamespaceId( realJobExecutorDTO.getNamespaceId() );
        jobExecutorResultDTO.setGroupName( realJobExecutorDTO.getGroupName() );
        jobExecutorResultDTO.setTaskType( realJobExecutorDTO.getTaskType() );
        jobExecutorResultDTO.setWfContext( realJobExecutorDTO.getWfContext() );
        jobExecutorResultDTO.setRetryStatus( realJobExecutorDTO.getRetryStatus() );

        return jobExecutorResultDTO;
    }

    @Override
    public RealStopTaskInstanceDTO toRealStopTaskInstanceDTO(TaskStopJobContext context) {
        if ( context == null ) {
            return null;
        }

        RealStopTaskInstanceDTO realStopTaskInstanceDTO = new RealStopTaskInstanceDTO();

        realStopTaskInstanceDTO.setJobId( context.getJobId() );
        realStopTaskInstanceDTO.setTaskBatchId( context.getTaskBatchId() );
        realStopTaskInstanceDTO.setGroupName( context.getGroupName() );
        realStopTaskInstanceDTO.setNamespaceId( context.getNamespaceId() );
        realStopTaskInstanceDTO.setTaskType( context.getTaskType() );

        return realStopTaskInstanceDTO;
    }

    @Override
    public List<JobPartitionTaskDTO> toJobPartitionTasks(List<Job> jobs) {
        if ( jobs == null ) {
            return null;
        }

        List<JobPartitionTaskDTO> list = new ArrayList<JobPartitionTaskDTO>( jobs.size() );
        for ( Job job : jobs ) {
            list.add( jobToJobPartitionTaskDTO( job ) );
        }

        return list;
    }

    @Override
    public List<JobPartitionTaskDTO> toJobTaskBatchPartitionTasks(List<JobTaskBatch> jobTaskBatches) {
        if ( jobTaskBatches == null ) {
            return null;
        }

        List<JobPartitionTaskDTO> list = new ArrayList<JobPartitionTaskDTO>( jobTaskBatches.size() );
        for ( JobTaskBatch jobTaskBatch : jobTaskBatches ) {
            list.add( jobTaskBatchToJobPartitionTaskDTO( jobTaskBatch ) );
        }

        return list;
    }

    @Override
    public JobTaskBatch toJobTaskBatch(JobTaskBatchGeneratorContext context) {
        if ( context == null ) {
            return null;
        }

        JobTaskBatch jobTaskBatch = new JobTaskBatch();

        jobTaskBatch.setNamespaceId( context.getNamespaceId() );
        jobTaskBatch.setGroupName( context.getGroupName() );
        jobTaskBatch.setJobId( context.getJobId() );
        jobTaskBatch.setWorkflowTaskBatchId( context.getWorkflowTaskBatchId() );
        jobTaskBatch.setWorkflowNodeId( context.getWorkflowNodeId() );
        jobTaskBatch.setParentWorkflowNodeId( context.getParentWorkflowNodeId() );
        jobTaskBatch.setTaskBatchStatus( context.getTaskBatchStatus() );
        jobTaskBatch.setOperationReason( context.getOperationReason() );

        return jobTaskBatch;
    }

    @Override
    public CompleteJobBatchDTO toCompleteJobBatchDTO(JobExecutorResultDTO jobExecutorResultDTO) {
        if ( jobExecutorResultDTO == null ) {
            return null;
        }

        CompleteJobBatchDTO completeJobBatchDTO = new CompleteJobBatchDTO();

        completeJobBatchDTO.setGroupName( jobExecutorResultDTO.getGroupName() );
        completeJobBatchDTO.setNamespaceId( jobExecutorResultDTO.getNamespaceId() );
        completeJobBatchDTO.setTaskId( jobExecutorResultDTO.getTaskId() );
        completeJobBatchDTO.setJobId( jobExecutorResultDTO.getJobId() );
        completeJobBatchDTO.setWorkflowNodeId( jobExecutorResultDTO.getWorkflowNodeId() );
        completeJobBatchDTO.setWorkflowTaskBatchId( jobExecutorResultDTO.getWorkflowTaskBatchId() );
        completeJobBatchDTO.setTaskBatchId( jobExecutorResultDTO.getTaskBatchId() );
        completeJobBatchDTO.setJobOperationReason( jobExecutorResultDTO.getJobOperationReason() );
        completeJobBatchDTO.setResult( jobExecutorResultDTO.getResult() );
        completeJobBatchDTO.setMessage( jobExecutorResultDTO.getMessage() );
        completeJobBatchDTO.setTaskType( jobExecutorResultDTO.getTaskType() );
        completeJobBatchDTO.setRetryStatus( jobExecutorResultDTO.getRetryStatus() );

        return completeJobBatchDTO;
    }

    @Override
    public CompleteJobBatchDTO completeJobBatchDTO(JobTaskPrepareDTO jobTaskPrepareDTO) {
        if ( jobTaskPrepareDTO == null ) {
            return null;
        }

        CompleteJobBatchDTO completeJobBatchDTO = new CompleteJobBatchDTO();

        completeJobBatchDTO.setGroupName( jobTaskPrepareDTO.getGroupName() );
        completeJobBatchDTO.setNamespaceId( jobTaskPrepareDTO.getNamespaceId() );
        completeJobBatchDTO.setClientId( jobTaskPrepareDTO.getClientId() );
        completeJobBatchDTO.setJobId( jobTaskPrepareDTO.getJobId() );
        completeJobBatchDTO.setWorkflowNodeId( jobTaskPrepareDTO.getWorkflowNodeId() );
        completeJobBatchDTO.setWorkflowTaskBatchId( jobTaskPrepareDTO.getWorkflowTaskBatchId() );
        completeJobBatchDTO.setTaskBatchId( jobTaskPrepareDTO.getTaskBatchId() );
        completeJobBatchDTO.setTaskType( jobTaskPrepareDTO.getTaskType() );

        return completeJobBatchDTO;
    }

    @Override
    public JobLogMessage toJobLogMessage(JobLogMessage jobLogMessage) {
        if ( jobLogMessage == null ) {
            return null;
        }

        JobLogMessage jobLogMessage1 = new JobLogMessage();

        jobLogMessage1.setCreateDt( jobLogMessage.getCreateDt() );
        jobLogMessage1.setId( jobLogMessage.getId() );
        jobLogMessage1.setNamespaceId( jobLogMessage.getNamespaceId() );
        jobLogMessage1.setGroupName( jobLogMessage.getGroupName() );
        jobLogMessage1.setJobId( jobLogMessage.getJobId() );
        jobLogMessage1.setTaskBatchId( jobLogMessage.getTaskBatchId() );
        jobLogMessage1.setTaskId( jobLogMessage.getTaskId() );
        jobLogMessage1.setLogNum( jobLogMessage.getLogNum() );
        jobLogMessage1.setMessage( jobLogMessage.getMessage() );
        jobLogMessage1.setRealTime( jobLogMessage.getRealTime() );

        return jobLogMessage1;
    }

    @Override
    public ReduceTaskDTO toReduceTaskDTO(JobExecutorResultContext context) {
        if ( context == null ) {
            return null;
        }

        ReduceTaskDTO reduceTaskDTO = new ReduceTaskDTO();

        reduceTaskDTO.setWorkflowNodeId( context.getWorkflowNodeId() );
        reduceTaskDTO.setWorkflowTaskBatchId( context.getWorkflowTaskBatchId() );
        reduceTaskDTO.setTaskBatchId( context.getTaskBatchId() );
        reduceTaskDTO.setJobId( context.getJobId() );

        return reduceTaskDTO;
    }

    @Override
    public JobExecutorResultContext toJobExecutorResultContext(CompleteJobBatchDTO completeJobBatchDTO) {
        if ( completeJobBatchDTO == null ) {
            return null;
        }

        JobExecutorResultContext jobExecutorResultContext = new JobExecutorResultContext();

        jobExecutorResultContext.setJobId( completeJobBatchDTO.getJobId() );
        jobExecutorResultContext.setTaskBatchId( completeJobBatchDTO.getTaskBatchId() );
        jobExecutorResultContext.setGroupName( completeJobBatchDTO.getGroupName() );
        jobExecutorResultContext.setNamespaceId( completeJobBatchDTO.getNamespaceId() );
        jobExecutorResultContext.setTaskId( completeJobBatchDTO.getTaskId() );
        jobExecutorResultContext.setTaskType( completeJobBatchDTO.getTaskType() );
        jobExecutorResultContext.setClientId( completeJobBatchDTO.getClientId() );
        jobExecutorResultContext.setWorkflowNodeId( completeJobBatchDTO.getWorkflowNodeId() );
        jobExecutorResultContext.setWorkflowTaskBatchId( completeJobBatchDTO.getWorkflowTaskBatchId() );
        jobExecutorResultContext.setJobOperationReason( completeJobBatchDTO.getJobOperationReason() );
        jobExecutorResultContext.setMessage( completeJobBatchDTO.getMessage() );

        return jobExecutorResultContext;
    }

    @Override
    public List<JobAlarmInfo> toJobTaskFailAlarmEventDTO(List<JobTaskFailAlarmEventDTO> jobTaskFailAlarmEventDTOList) {
        if ( jobTaskFailAlarmEventDTOList == null ) {
            return null;
        }

        List<JobAlarmInfo> list = new ArrayList<JobAlarmInfo>( jobTaskFailAlarmEventDTOList.size() );
        for ( JobTaskFailAlarmEventDTO jobTaskFailAlarmEventDTO : jobTaskFailAlarmEventDTOList ) {
            list.add( toJobAlarmInfo( jobTaskFailAlarmEventDTO ) );
        }

        return list;
    }

    @Override
    public JobAlarmInfo toJobAlarmInfo(JobTaskFailAlarmEventDTO jobTaskFailAlarmEventDTO) {
        if ( jobTaskFailAlarmEventDTO == null ) {
            return null;
        }

        JobAlarmInfo jobAlarmInfo = new JobAlarmInfo();

        jobAlarmInfo.setId( jobTaskFailAlarmEventDTO.getJobTaskBatchId() );
        jobAlarmInfo.setNotifyScene( jobTaskFailAlarmEventDTO.getNotifyScene() );
        jobAlarmInfo.setReason( jobTaskFailAlarmEventDTO.getReason() );

        return jobAlarmInfo;
    }

    protected JobPartitionTaskDTO jobToJobPartitionTaskDTO(Job job) {
        if ( job == null ) {
            return null;
        }

        JobPartitionTaskDTO jobPartitionTaskDTO = new JobPartitionTaskDTO();

        jobPartitionTaskDTO.setId( job.getId() );
        jobPartitionTaskDTO.setNamespaceId( job.getNamespaceId() );
        jobPartitionTaskDTO.setGroupName( job.getGroupName() );
        if ( job.getNextTriggerAt() != null ) {
            jobPartitionTaskDTO.setNextTriggerAt( job.getNextTriggerAt() );
        }
        jobPartitionTaskDTO.setBlockStrategy( job.getBlockStrategy() );
        jobPartitionTaskDTO.setTriggerType( job.getTriggerType() );
        jobPartitionTaskDTO.setTriggerInterval( job.getTriggerInterval() );
        jobPartitionTaskDTO.setExecutorTimeout( job.getExecutorTimeout() );
        jobPartitionTaskDTO.setTaskType( job.getTaskType() );
        jobPartitionTaskDTO.setResident( job.getResident() );

        return jobPartitionTaskDTO;
    }

    protected JobPartitionTaskDTO jobTaskBatchToJobPartitionTaskDTO(JobTaskBatch jobTaskBatch) {
        if ( jobTaskBatch == null ) {
            return null;
        }

        JobPartitionTaskDTO jobPartitionTaskDTO = new JobPartitionTaskDTO();

        jobPartitionTaskDTO.setId( jobTaskBatch.getId() );
        jobPartitionTaskDTO.setNamespaceId( jobTaskBatch.getNamespaceId() );
        jobPartitionTaskDTO.setGroupName( jobTaskBatch.getGroupName() );

        return jobPartitionTaskDTO;
    }
}
