/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.starter.listener;

import com.aizuda.snailjob.common.core.util.SnailJobVersion;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class StartListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(StartListener.class);
    private final List<Lifecycle> lifecycleList;
    private volatile boolean isStarted = false;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.isStarted) {
            SnailJobLog.LOCAL.info("snail-job server already started v{}", new Object[]{SnailJobVersion.getVersion()});
            return;
        }
        System.out.println(MessageFormatter.format((String)"  ______                  _  __       _____      __        \n.' ____ \\                (_)[  |     |_   _|    [  |       \n| (___ \\_| _ .--.  ,--.  __  | |       | | .--.  | |.--.   \n _.____`. [ `.-. |`'_\\ :[  | | |   _   | / .'`\\ \\| '/'`\\ \\ \n| \\____) | | | | |// | |,| | | |  | |__' | \\__. ||  \\__/ | \n \\______.'[___||__]'-;__[___|___] `.____.''.__.'[__;.__.'  \n:: Snail Job ::                                 (v{})  \n", (Object)SnailJobVersion.getVersion()).getMessage());
        SnailJobLog.LOCAL.info("snail-job server is preparing to start... v{}", new Object[]{SnailJobVersion.getVersion()});
        this.lifecycleList.forEach(Lifecycle::start);
        SnailJobLog.LOCAL.info("snail-job server started successfully v{}", new Object[]{SnailJobVersion.getVersion()});
        this.isStarted = true;
    }

    public StartListener(List<Lifecycle> lifecycleList) {
        this.lifecycleList = lifecycleList;
    }
}

