/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server;

import com.aizuda.snailjob.server.common.rpc.server.GrpcServer;
import com.aizuda.snailjob.server.common.rpc.server.NettyHttpServer;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication(scanBasePackages={"com.aizuda.snailjob.server.starter.*"})
@EnableTransactionManagement(proxyTargetClass=true)
public class SnailJobServerApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnailJobServerApplication.class);

    public static void main(String[] args) {
        TimeZone.setDefault(TimeZone.getTimeZone("Asia/Shanghai"));
        SpringApplication.run(SnailJobServerApplication.class, (String[])args);
    }

    @Bean
    public ApplicationRunner nettyStartupChecker(NettyHttpServer nettyHttpServer, GrpcServer grpcServer, ServletWebServerFactory serverFactory) {
        return args -> {
            boolean started = nettyHttpServer.isStarted() || grpcServer.isStarted();
            for (int waitCount = 0; !started && waitCount < 100; ++waitCount) {
                log.info("--------> snail-job server is staring....");
                TimeUnit.MILLISECONDS.sleep(100L);
                started = nettyHttpServer.isStarted() || grpcServer.isStarted();
            }
            if (!started) {
                log.error("--------> snail-job server startup failure.");
                serverFactory.getWebServer(new ServletContextInitializer[0]).stop();
                SpringApplication.exit((ApplicationContext)SpringApplication.run(SnailJobServerApplication.class, (String[])new String[0]), (ExitCodeGenerator[])new ExitCodeGenerator[0]);
            }
        };
    }
}

