/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.job.task.dto.WorkflowNodeTaskExecuteDTO;
import com.aizuda.snailjob.server.job.task.support.handler.WorkflowBatchHandler;
import com.aizuda.snailjob.server.web.service.WorkflowNodeService;
import com.aizuda.snailjob.server.web.service.handler.JobHandler;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkflowNodeServiceImpl
implements WorkflowNodeService {
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final JobMapper jobMapper;
    private final WorkflowBatchHandler workflowBatchHandler;
    private final JobHandler jobHandler;

    @Override
    @Transactional
    public Boolean stop(Long nodeId, Long workflowTaskBatchId) {
        List jobTaskBatches = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getWorkflowNodeId, (Object)nodeId)).eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)workflowTaskBatchId)).in(JobTaskBatch::getTaskBatchStatus, (Collection)JobTaskBatchStatusEnum.NOT_COMPLETE));
        if (CollUtil.isEmpty((Collection)jobTaskBatches)) {
            return Boolean.TRUE;
        }
        for (JobTaskBatch jobTaskBatch : jobTaskBatches) {
            this.jobHandler.stop(jobTaskBatch.getId());
        }
        WorkflowNodeTaskExecuteDTO taskExecuteDTO = new WorkflowNodeTaskExecuteDTO();
        taskExecuteDTO.setWorkflowTaskBatchId(workflowTaskBatchId);
        taskExecuteDTO.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_WORKFLOW.getType());
        taskExecuteDTO.setParentId(nodeId);
        this.workflowBatchHandler.openNextNode(taskExecuteDTO);
        return Boolean.TRUE;
    }

    @Override
    @Transactional
    public Boolean retry(Long nodeId, Long workflowTaskBatchId) {
        List jobTaskBatches = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{JobTaskBatch::getId}).eq(JobTaskBatch::getWorkflowNodeId, (Object)nodeId)).eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)workflowTaskBatchId)).in(JobTaskBatch::getTaskBatchStatus, (Collection)JobTaskBatchStatusEnum.NOT_SUCCESS));
        Assert.notEmpty((Iterable)jobTaskBatches, () -> new SnailJobServerException("job task batch is empty."));
        for (JobTaskBatch jobTaskBatch : jobTaskBatches) {
            this.jobHandler.retry(jobTaskBatch.getId(), nodeId, workflowTaskBatchId);
        }
        return Boolean.TRUE;
    }

    public WorkflowNodeServiceImpl(JobTaskBatchMapper jobTaskBatchMapper, JobMapper jobMapper, WorkflowBatchHandler workflowBatchHandler, JobHandler jobHandler) {
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.jobMapper = jobMapper;
        this.workflowBatchHandler = workflowBatchHandler;
        this.jobHandler = jobHandler;
    }
}

