/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs;

import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.logger.LogHelper;
import java.io.File;

public class Version {
    private static final LogHelper LOGGER = LogHelper.getLog(Version.class);
    public static boolean isDebug;
    public static final String srcFolder;
    private static final String OS_NAME;
    public static final boolean isMac;
    public static final boolean isWindows;
    public static final boolean isLinux;

    private static boolean isRunningTest() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement e : stackTrace = Thread.currentThread().getStackTrace()) {
            if (e.toString().lastIndexOf("junit.runners") <= -1) continue;
            return true;
        }
        return false;
    }

    public static void tomcatVersionDetect(String serverInfo) {
        String result = CommonUtil.regMatch("(?<=Tomcat/)(\\d)", serverInfo);
        if (result != null) {
            try {
                if (Integer.parseInt(result) < 8) {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u4f4e\u4e8e Tomcat 8 \u4ee5\u4e0b\u7684\u7248\u672c\uff01");
                }
            }
            catch (Throwable e) {
                if (e instanceof UnsupportedOperationException) {
                    throw e;
                }
                LOGGER.warning(e);
            }
        }
    }

    static {
        srcFolder = new File(Version.class.getClassLoader().getResource("").getPath()).toString();
        OS_NAME = System.getProperty("os.name").toLowerCase();
        isMac = OS_NAME.contains("mac");
        isWindows = OS_NAME.contains("window");
        isLinux = OS_NAME.contains("linux");
        System.setProperty("user.timezone", "GMT +08");
        String vendor = System.getProperty("java.vm.vendor");
        if (vendor.indexOf("Oracle") == -1 || vendor.contains("openJDK")) {
            LOGGER.warning("\u62b1\u6b49\uff0c\u672c\u6846\u67b6\u6682\u4e0d\u652f\u6301 OpenJDK\u3002 \u5982\u679c\u4f60\u662f Linux \u7cfb\u7edf\uff0c\u8bf7\u628a\u81ea\u5e26\u7684 OpenJDK \u5378\u8f7d\uff0c\u6539\u7528 Oracle JVM");
            System.exit(1);
        }
        if (Double.parseDouble(System.getProperty("java.specification.version")) < 1.5) {
            LOGGER.warning("\u8bf7\u5347\u7ea7\u4f60\u7684 JRE/JDK\u7248\u672c >= 1.8");
            System.exit(1);
        }
        boolean bl = isDebug = OS_NAME.indexOf("nix") < 0 && OS_NAME.indexOf("nux") < 0 && OS_NAME.indexOf("aix") <= 0;
        if (!Version.isRunningTest()) {
            LOGGER.infoYellow("\n     ___       _       ___  __    __      _   _____        _          __  _____   _____  \n     /   |     | |     /   | \\ \\  / /     | | /  ___/      | |        / / | ____| |  _  \\ \n    / /| |     | |    / /| |  \\ \\/ /      | | | |___       | |  __   / /  | |__   | |_| |  \n   / / | |  _  | |   / / | |   }  {    _  | | \\___  \\      | | /  | / /   |  __|  |  _  {  \n  / /  | | | |_| |  / /  | |  / /\\ \\  | |_| |  ___| |      | |/   |/ /    | |___  | |_| |  \n /_/   |_| \\_____/ /_/   |_| /_/  \\_\\ \\_____/ /_____/      |___/|___/     |_____| |_____/ \n");
            LOGGER.infoGreen("AJAXJS-Base \u52a0\u8f7d\u5b8c\u6bd5\uff0c\u5f53\u524d\u662f[" + (isDebug ? "\u8c03\u8bd5" : "\u751f\u4ea7\u73af\u5883") + "]\u6a21\u5f0f");
        }
    }
}

