/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework;

import com.ajaxjs.framework.BaseModel;
import com.ajaxjs.sql.orm.IBaseService;
import com.ajaxjs.sql.orm.PageResult;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.util.map.JsonHelper;
import com.ajaxjs.web.mvc.IController;
import com.ajaxjs.web.mvc.ModelAndView;
import com.ajaxjs.web.mvc.MvcConstant;
import com.ajaxjs.web.mvc.MvcRequest;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class BaseController<T>
implements IController,
MvcConstant {
    private static final LogHelper LOGGER = LogHelper.getLog(BaseController.class);
    public static final String SHOW_405 = BaseController.jsonNoOk("405\uff0c Request method not supported \u7981\u6b62\u64cd\u4f5c");
    public static final String SHOW_401 = BaseController.jsonNoOk("401\uff0c Request method not supported \u6ca1\u6709\u6743\u9650");

    public abstract IBaseService<T> getService();

    public static String jsp(String jsp) {
        return "/WEB-INF/jsp/" + jsp;
    }

    public static String page(String jsp) {
        return BaseController.jsp("pages/" + jsp);
    }

    public static String admin(String jsp) {
        return BaseController.jsp("admin/" + jsp);
    }

    public void prepareData(ModelAndView mv) {
        IBaseService<T> service = this.getService();
        if (mv != null && service != null) {
            mv.put("uiName", service.getUiName());
            mv.put("shortName", service.getShortName());
            mv.put("tableName", service.getTableName());
        }
    }

    public String createUI(ModelAndView mv) {
        mv.put("isCreate", true);
        this.prepareData(mv);
        return this.getService().getShortName();
    }

    public String create(T bean) {
        Long newlyId = this.getService().create(bean);
        if (newlyId == null) {
            throw new Error("\u521b\u5efa\u5931\u8d25\uff01");
        }
        return BaseController.jsonOk_Extension("\u521b\u5efa\u5b9e\u4f53\u6210\u529f", "\"newlyId\":" + newlyId);
    }

    private void setId(Long id, T bean) {
        if (bean instanceof BaseModel) {
            ((BaseModel)bean).setId(id);
        } else if (bean instanceof Map) {
            ((Map)bean).put("id", id);
        } else {
            LOGGER.warning("\u672a\u77e5\u5b9e\u4f53\u7c7b\u578b " + bean.getClass().getName());
        }
    }

    public String update(Long id, T bean) {
        LOGGER.info("\u4fee\u6539 name:{0}\uff0c\u6570\u636e\u5e93\u5c06\u6267\u884c UPDATE \u64cd\u4f5c", bean);
        this.setId(id, bean);
        this.getService().update(bean);
        return BaseController.jsonOk("\u4fee\u6539\u6210\u529f");
    }

    public String delete(Long id, T bean) {
        LOGGER.info("\u5220\u9664 id:{0}\uff0c\u6570\u636e\u5e93\u5c06\u6267\u884c DELETE \u64cd\u4f5c", bean);
        this.setId(id, bean);
        if (!this.getService().delete(bean)) {
            throw new Error("\u5220\u9664\u5931\u8d25\uff01");
        }
        return BaseController.jsonOk("\u5220\u9664\u6210\u529f");
    }

    public static String autoOutput(Object entity, ModelAndView mv, String jspPath) {
        return BaseController.autoOutput(entity, mv, jspPath, null);
    }

    public static String autoOutput(Object entity, ModelAndView mv, String jspPath, Function<Boolean, Boolean> fn) {
        if (fn != null && fn.apply(BaseController.isJson()).booleanValue() || fn == null && BaseController.isJson()) {
            if (entity instanceof PageResult) {
                return BaseController.toJson((PageResult)entity);
            }
            return BaseController.toJson(entity);
        }
        if (entity instanceof PageResult) {
            mv.put("PageResult", entity);
        }
        if (entity instanceof Map || entity instanceof BaseModel) {
            mv.put("info", entity);
        }
        if (jspPath.startsWith("jsp::")) {
            return BaseController.jsp(jspPath.replace("jsp::", ""));
        }
        if (jspPath.startsWith("page::")) {
            return BaseController.page(jspPath.replace("page::", ""));
        }
        if (jspPath.startsWith("admin::")) {
            return BaseController.admin(jspPath.replace("admin::", ""));
        }
        return jspPath;
    }

    public String output(ModelAndView mv, Object entityOrId) {
        String name = this.getService().getShortName();
        String jspPath = entityOrId instanceof PageResult ? name + "-list" : name;
        return this.output(mv, entityOrId, jspPath);
    }

    public String output(ModelAndView mv, Object entityOrId, String jspPath) {
        return this.output(mv, entityOrId, jspPath, null);
    }

    public String output(ModelAndView mv, Object entityOrId, String jspPath, Consumer<T> onGetInfo) {
        if (entityOrId instanceof Long) {
            entityOrId = this.getService().findById((long)((Long)entityOrId));
        }
        if (onGetInfo != null) {
            onGetInfo.accept(entityOrId);
        }
        this.prepareData(mv);
        return BaseController.autoOutput(entityOrId, mv, jspPath);
    }

    public static boolean isJson() {
        String accept = MvcRequest.getHttpServletRequest().getHeader("Accept");
        return accept != null && "application/json".equals(accept);
    }

    public static String toJson(Object obj) {
        return BaseController.toJson(obj, true, true);
    }

    public static String toJson(Object obj, boolean isAddPerfix, boolean isAddResult) {
        String jsonStr = JsonHelper.toJson(obj);
        if (isAddResult) {
            jsonStr = "{\"result\":" + jsonStr + "}";
        }
        if (isAddPerfix) {
            jsonStr = "json::" + jsonStr;
        }
        return jsonStr;
    }

    public static String toJson(PageResult<?> pageResult) {
        String jsonStr = BaseController.toJson(pageResult, true, false);
        if (jsonStr == null || pageResult == null) {
            jsonStr = "[]";
        }
        int total = pageResult == null || pageResult.isZero() ? 0 : pageResult.getTotalCount();
        return BaseController.jsonOk_Extension("\u5206\u9875\u5217\u8868", "\"result\":" + jsonStr + ",\"total\":" + total);
    }

    public static String jsonOk(String msg) {
        return String.format("json::{\"isOk\": true, \"msg\" : \"%s\"}", JsonHelper.javaValue2jsonValue(msg));
    }

    public static String jsonOk() {
        return BaseController.jsonOk("\u64cd\u4f5c\u6210\u529f\uff01");
    }

    public static String jsonOk_Extension(Object ... msg) {
        return String.format("json::{\"isOk\": true, \"msg\" : \"%s\", %s}", msg);
    }

    public static String jsonNoOk(String msg) {
        return String.format("json::{\"isOk\": false, \"msg\" : \"%s\"}", JsonHelper.jsonString_covernt(msg));
    }

    public static String jsonNoOk() {
        return BaseController.jsonNoOk("\u64cd\u4f5c\u5931\u8d25\uff01");
    }
}

