/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework;

import com.ajaxjs.framework.BaseModel;
import com.ajaxjs.framework.QueryTools;
import com.ajaxjs.sql.SnowflakeId;
import com.ajaxjs.sql.orm.IBaseDao;
import com.ajaxjs.sql.orm.IBaseService;
import com.ajaxjs.sql.orm.PageResult;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.web.mvc.MvcRequest;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class BaseService<T>
extends QueryTools
implements IBaseService<T> {
    private IBaseDao<T> dao;
    private String uiName;
    private String tableName;
    private String shortName;
    public static final int defaultPageSize = 6;

    @Override
    public T findById(Long id) {
        return this.dao.findById(id);
    }

    public T findByUid(long uid) {
        return this.dao.find(BaseService.byUid(uid));
    }

    @Override
    public Long create(T bean) {
        BaseService.initCreate(bean);
        return this.dao.create(bean);
    }

    public static void initCreate(Object bean) {
        Objects.requireNonNull(bean, "Bean \u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        if (bean instanceof BaseModel) {
            BaseModel model = (BaseModel)bean;
            if (model.getUid() == null) {
                model.setUid(SnowflakeId.get());
            }
            Date now = new Date();
            if (model.getCreateDate() == null) {
                model.setCreateDate(now);
            }
            if (model.getUpdateDate() == null) {
                model.setUpdateDate(now);
            }
        } else if (bean instanceof Map) {
            Map map = (Map)bean;
            if (map.get("uid") == null) {
                map.put("uid", SnowflakeId.get());
            }
            Date now = new Date();
            Object createDate = map.get("createDate");
            if (createDate == null || createDate != null && CommonUtil.isEmptyString(createDate.toString())) {
                map.put("createDate", now);
            }
            if (map.get("updateDate") == null) {
                map.put("updateDate", now);
            }
        }
    }

    @Override
    public int update(T bean) {
        BaseService.initUpdate(bean);
        return this.dao.update(bean);
    }

    public static void initUpdate(Object bean) {
        Map map;
        Date now = new Date();
        if (bean instanceof BaseModel) {
            BaseModel model = (BaseModel)bean;
            if (model.getUpdateDate() == null) {
                model.setUpdateDate(now);
            }
        } else if (bean instanceof Map && (map = (Map)bean).get("updateDate") == null) {
            map.put("updateDate", now);
        }
    }

    @Override
    public boolean delete(T bean) {
        return this.dao.delete(bean);
    }

    @Override
    public List<T> findList() {
        return this.dao.findList(null);
    }

    @Override
    public List<T> findList(Function<String, String> sqlHandler) {
        return this.dao.findList(sqlHandler);
    }

    @Override
    public PageResult<T> findPagedList(int start, int limit) {
        return this.dao.findPagedList(start, limit, null);
    }

    @Override
    public PageResult<T> findPagedList(int start, int limit, Function<String, String> sqlHandler) {
        return this.dao.findPagedList(start, limit, sqlHandler);
    }

    public PageResult<T> findPagedList(int catalogId, int start, int limit, int status, boolean isSimpleCatalog) {
        Function<String, String> fn = BaseService.setStatus(status).andThen(BaseService::searchQuery).andThen(BaseService.byAny());
        return this.dao.findPagedList(start, limit, fn);
    }

    @Override
    public IBaseDao<T> getDao() {
        return this.dao;
    }

    public void setDao(IBaseDao<T> dao) {
        this.dao = dao;
    }

    @Override
    public String getUiName() {
        return this.uiName;
    }

    public void setUiName(String uiName) {
        this.uiName = uiName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public static Function<String, String> byAny() {
        return BaseService.byAny(MvcRequest.getHttpServletRequest());
    }

    public static String searchQuery(String sql) {
        return BaseService.searchQuery(new String[]{"name", "content"}, MvcRequest.getHttpServletRequest()).apply(sql);
    }

    public static String searchQuery_NameOnly(String sql) {
        return BaseService.searchQuery(new String[]{"name"}, MvcRequest.getHttpServletRequest()).apply(sql);
    }

    public static String betweenCreateDate(String sql) {
        return BaseService.betweenCreateDate("createDate", MvcRequest.getHttpServletRequest()).apply(sql);
    }

    public static String betweenCreateDateWithE(String sql) {
        return BaseService.betweenCreateDate("e.createDate", MvcRequest.getHttpServletRequest()).apply(sql);
    }
}

