/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework;

import com.ajaxjs.sql.JdbcConnection;
import com.ajaxjs.sql.JdbcHelper;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.MappingValue;
import com.ajaxjs.web.ServletHelper;
import com.ajaxjs.web.mvc.MvcRequest;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;

public class QueryTools {
    public static String orderById_DESC(String sql) {
        return sql + " ORDER BY id DESC";
    }

    public static Function<String, String> orderBy(String o) {
        return sql -> sql + " ORDER BY " + o;
    }

    public static Function<String, String> top(int top) {
        return sql -> sql + " LIMIT 0, " + top;
    }

    public static String where(String sql, String where) {
        return sql.replace("1 = 1", "(" + where + ")" + " AND 1 = 1");
    }

    public static String equals(String field, Object value) {
        if (value instanceof String) {
            value = "'" + value + "'";
        }
        return field + " = " + value;
    }

    public static String where(String sql, String field, Object value) {
        return QueryTools.where(sql, QueryTools.equals(field, value));
    }

    public static Function<String, String> setWhere(String where) {
        return where == null ? sql -> sql : sql -> QueryTools.where(sql, where);
    }

    public static Function<String, String> by(String field, Object value) {
        return QueryTools.setWhere(QueryTools.equals(field, value));
    }

    public static Object getValue(HttpServletRequest r, String query, Class<?> type) {
        if (r != null && r.getParameter(query) != null) {
            String _v = r.getParameter(query);
            Object v = null;
            if (type == String.class) {
                if (!ServletHelper.preventSQLInject(_v)) {
                    return QueryTools.setWhere(null);
                }
                v = _v;
            } else if (type == Long.class || type == Long.TYPE) {
                v = Long.parseLong(_v);
            } else if (type == Integer.class || type == Integer.TYPE) {
                v = Integer.parseInt(_v);
            }
            return v;
        }
        return null;
    }

    public static Object getValue(String query, Class<?> type) {
        return QueryTools.getValue(MvcRequest.getHttpServletRequest(), query, type);
    }

    public static Function<String, String> by(String query, Class<?> type, String field) {
        return sql -> {
            Object v = QueryTools.getValue(query, type);
            return v == null ? sql : QueryTools.where(sql, field, v);
        };
    }

    public static Function<String, String> byUid(long uid) {
        return QueryTools.by("uid", uid);
    }

    public static Function<String, String> byUserId(long userId) {
        return QueryTools.by("userId", userId);
    }

    public static Function<String, String> in(String field, String[] values) {
        return QueryTools.setWhere(field + " IN (" + String.join((CharSequence)",", values) + ")");
    }

    public static Function<String, String> setStatus(int status) {
        switch (status) {
            case 2: {
                return QueryTools.setWhere(null);
            }
            case 1: {
                return QueryTools.setWhere("stat = 1 OR stat IS NULL");
            }
        }
        return QueryTools.setWhere("stat = 0 OR stat = 1 OR stat is NULL");
    }

    public static Function<String, String> likeSqlHandler(String field, String keyword, boolean isExact) {
        if (!isExact) {
            keyword = "%" + keyword + "%";
        }
        return QueryTools.setWhere(field + "LIKE ");
    }

    public static Function<String, String> byAny(HttpServletRequest r) {
        String value = r.getParameter("filterValue");
        if (value == null || "null".equals(value)) {
            return QueryTools.setWhere(null);
        }
        return QueryTools.by(r.getParameter("filterField"), value.matches("\\d+") ? MappingValue.toJavaValue(value) : value);
    }

    public static Function<String, String> searchQuery(String[] fields, HttpServletRequest r) {
        if (r == null || CommonUtil.isEmptyString(r.getParameter("keyword"))) {
            return QueryTools.setWhere(null);
        }
        String keyword = r.getParameter("keyword").trim();
        String isExact = r.getParameter("isExact");
        if (!ServletHelper.preventSQLInject(keyword)) {
            return QueryTools.setWhere(null);
        }
        keyword = ServletHelper.MysqlRealScapeString(keyword);
        String like = MappingValue.toBoolean(isExact) ? keyword : "'%" + keyword + "%'";
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = fields[i] + " LIKE " + like;
        }
        return QueryTools.setWhere(String.join((CharSequence)" OR ", fields));
    }

    public static Function<String, String> betweenCreateDate(String fieldName, HttpServletRequest r) {
        if (r == null) {
            return QueryTools.setWhere(null);
        }
        String startDate = r.getParameter("startDate");
        String endDate = r.getParameter("endDate");
        if (r == null || CommonUtil.isEmptyString(startDate) || CommonUtil.isEmptyString(endDate)) {
            return QueryTools.setWhere(null);
        }
        if (!ServletHelper.preventSQLInject(startDate) || !ServletHelper.preventSQLInject(endDate)) {
            return QueryTools.setWhere(null);
        }
        return QueryTools.setWhere(fieldName + " BETWEEN '" + startDate + "' AND DATE_ADD('" + endDate + "', INTERVAL 1 DAY)");
    }

    public static void getNeighbor(Map<String, Object> map, String tableName, Serializable id) {
        Map<String, Object> perv = JdbcHelper.queryAsMap(JdbcConnection.getConnection(), "SELECT id, name FROM " + tableName + " WHERE id < ? ORDER BY id DESC LIMIT 1", id);
        Map<String, Object> next = JdbcHelper.queryAsMap(JdbcConnection.getConnection(), "SELECT id, name FROM " + tableName + " WHERE id > ? LIMIT 1", id);
        map.put("neighbor_pervInfo", perv);
        map.put("neighbor_nextInfo", next);
    }
}

