/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework.config;

import com.ajaxjs.framework.BaseController;
import com.ajaxjs.framework.config.ConfigService;
import com.ajaxjs.framework.config.SiteStruService;
import com.ajaxjs.util.XmlHelper;
import com.ajaxjs.util.io.FileHelper;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.web.mvc.IController;
import com.ajaxjs.web.mvc.ModelAndView;
import com.ajaxjs.web.mvc.MvcRequest;
import java.io.File;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/admin/common/config")
public class ConfigController
implements IController {
    private static final LogHelper LOGGER = LogHelper.getLog(ConfigController.class);

    @GET
    public String config(ModelAndView mv, MvcRequest r) {
        LOGGER.info("\u53c2\u6570\u914d\u7f6e");
        mv.put("conn", XmlHelper.nodeAsMap(r.mappath("/META-INF/context.xml"), "//Resource[@name='" + ConfigService.get("data.database_node") + "']"));
        ConfigController.loadJson(mv);
        return BaseController.jsp("common/config");
    }

    private static void loadJson(ModelAndView model) {
        model.put("configJson", FileHelper.openAsText(ConfigService.jsonPath));
        model.put("schemeJson", ConfigService.getSchemeJson());
    }

    @POST
    @Produces(value={"application/json"})
    public String saveAllconfig(Map<String, Object> map, HttpServletRequest request) {
        LOGGER.info("\u4fdd\u5b58\u914d\u7f6e\u5e76\u4e14\u5237\u65b0\u914d\u7f6e");
        ConfigService.loadJSON_in_JS(map);
        ConfigService.load(ConfigService.jsonPath);
        if (request.getServletContext().getAttribute("aj_allConfig") != null) {
            request.getServletContext().setAttribute("aj_allConfig", ConfigService.CONFIG);
        }
        return BaseController.jsonOk("\u4fee\u6539\u914d\u7f6e\u6210\u529f\uff01");
    }

    @GET
    @Path(value="/admin/website/site")
    public String siteUI() {
        LOGGER.info("\u7f16\u8f91\u7f51\u7ad9\u4fe1\u606f");
        return BaseController.jsp("website/config-site-form");
    }

    @POST
    @Path(value="/admin/website/site")
    @Produces(value={"application/json"})
    public String saveSite(Map<String, Object> map, HttpServletRequest request) {
        LOGGER.info("\u4fdd\u5b58\u7f51\u7ad9\u4fe1\u606f");
        return this.saveAllconfig(map, request);
    }

    @GET
    @Path(value="/admin/website/siteStru")
    public String siteStruUI(ModelAndView model) {
        LOGGER.info("\u7f16\u8f91\u7f51\u7ad9\u7ed3\u6784");
        if (SiteStruService.STRU != null && SiteStruService.STRU.isLoaded()) {
            model.put("siteStruJson", FileHelper.openAsText(SiteStruService.STRU.getJsonPath()));
            return BaseController.jsp("website/config-site-stru");
        }
        return "err_msg::\u8be5\u7f51\u7ad9\u6ca1\u6709\u4f7f\u7528\u76ee\u5f55\u5b9a\u4e49\u529f\u80fd";
    }

    @POST
    @Path(value="/admin/website/siteStru")
    @Produces(value={"application/json"})
    public String saveSiteStru(@NotNull @FormParam(value="json") String json) {
        LOGGER.info("\u4fdd\u5b58\u7f51\u7ad9\u7ed3\u6784");
        FileHelper.saveText(SiteStruService.STRU.getJsonPath(), json);
        SiteStruService.loadSiteStru(MvcRequest.getHttpServletRequest().getServletContext());
        return BaseController.jsonOk("\u4fee\u6539\u7f51\u7ad9\u7ed3\u6784\u6210\u529f\uff01");
    }

    @POST
    @Path(value="/admin/website/siteStru/initJSP")
    @Produces(value={"application/json"})
    public String siteStruUI_initJSP(@FormParam(value="path") String path, MvcRequest r) {
        LOGGER.info("\u521d\u59cb\u5316 JSP \u9875\u9762");
        String folder = r.mappath(path);
        FileHelper.mkDir(folder);
        String dest = folder + File.separator + "index.jsp";
        FileHelper.copy(r.mappath("/WEB-INF/jsp" + File.separator + "common-page.jsp"), dest, true);
        return BaseController.jsonOk("\u521d\u59cb\u5316 JSP \u9875\u9762\u6210\u529f\uff01");
    }
}

