/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework.config;

import com.ajaxjs.Version;
import com.ajaxjs.framework.GetConfig;
import com.ajaxjs.framework.IComponent;
import com.ajaxjs.jsonparser.JsEngineWrapper;
import com.ajaxjs.util.io.FileHelper;
import com.ajaxjs.util.io.StreamHelper;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.util.map.JsonHelper;
import com.ajaxjs.util.map.ListMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.script.ScriptException;

public class ConfigService
implements GetConfig,
IComponent {
    private static final LogHelper LOGGER = LogHelper.getLog(ConfigService.class);
    public static String jsonPath;
    public static String jsonStr;
    public static boolean isLoaded;
    public static Map<String, Object> CONFIG;
    public static Map<String, Object> FLAT_CONFIG;
    private static final String findNode = "function findNode(obj, queen) {\n\t\t\tif(!queen.shift) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t\tvar first = queen.shift();\n \n\t\t\t\n\t\t\tfor(var i in obj) {\n\t\t\t\tif(i === first) {\n\t\t\t\t\tvar target = obj[i];\n\t\t\t\t\t\n\t\t\t\t\tif(queen.length == 0) {\n\t\t\t\t\t\t// \u627e\u5230\u4e86\n\t\t\t\t\t\treturn target;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn arguments.callee(obj[i], queen);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}";

    public static void load(String jsonPath) {
        if (!new File(jsonPath).exists()) {
            LOGGER.info("\u6ca1\u6709[{0}]\u9879\u76ee\u914d\u7f6e\u6587\u4ef6", jsonPath);
            return;
        }
        ConfigService.jsonPath = jsonPath;
        jsonStr = FileHelper.openAsText(jsonPath);
        CONFIG = JsonHelper.parseMap(jsonStr);
        isLoaded = true;
        FLAT_CONFIG = ListMap.flatMap(CONFIG);
        if (ConfigService.getValueAsBool("isForceProductEnv")) {
            LOGGER.infoGreen("\u5f3a\u5236\u4e3a\u751f\u4ea7\u73af\u5883\u6a21\u5f0f isDebug=false");
            Version.isDebug = false;
        }
        LOGGER.infoGreen("\u52a0\u8f7d[" + ConfigService.getValueAsString("clientShortName") + "]\u9879\u76ee\u914d\u7f6e\u6210\u529f\uff01All config loaded.");
    }

    public static void save() {
        jsonStr = JsonHelper.toJson(CONFIG);
        FileHelper.saveText(jsonPath, jsonStr);
    }

    private static <T> T get(String key, T isNullValue, Class<T> vType) {
        if (FLAT_CONFIG == null || !isLoaded) {
            return isNullValue;
        }
        Object v = FLAT_CONFIG.get(key);
        if (v == null) {
            LOGGER.warning("\u6ca1\u53d1\u73b0[{0}]\u914d\u7f6e", key);
            return isNullValue;
        }
        return (T)v;
    }

    public static boolean getValueAsBool(String key) {
        return ConfigService.get(key, false, Boolean.TYPE);
    }

    public static int getValueAsInt(String key) {
        return ConfigService.get(key, 0, Integer.TYPE);
    }

    public static long getValueAsLong(String key) {
        return ConfigService.get(key, 0L, Long.TYPE);
    }

    public static String getValueAsString(String key) {
        return ConfigService.get(key, null, String.class);
    }

    @Override
    public String getString(String key) {
        return ConfigService.getValueAsString(key);
    }

    public static String get(String key) {
        return ConfigService.getValueAsString(key);
    }

    public static int getInt(String key) {
        return ConfigService.getValueAsInt(key);
    }

    public static boolean getBol(String key) {
        return ConfigService.getValueAsBool(key);
    }

    public static String transform(String namespace) {
        String[] arr = namespace.split("\\.");
        if (arr.length < 1) {
            return null;
        }
        CharSequence[] arr2 = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            arr2[i] = "[\"" + arr[i] + "\"]";
        }
        return String.join((CharSequence)"", arr2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSchemeJson() {
        try (InputStream in = ConfigService.class.getResourceAsStream("ConfigScheme.json");){
            String string = StreamHelper.byteStream2string(in);
            return string;
        }
        catch (IOException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static void loadJSON_in_JS(Map<String, Object> map) {
        JsEngineWrapper js = new JsEngineWrapper();
        js.eval("allConfig = " + FileHelper.openAsText(jsonPath));
        map.forEach((k, v) -> {
            String jsKey = ConfigService.transform(k);
            String jsCode = "";
            if (v == null) {
                jsCode = String.format("allConfig%s = null;", jsKey);
            } else {
                Object obj2;
                String type = null;
                try {
                    obj2 = js.getEngine().eval("typeof allConfig" + jsKey);
                    if (obj2 != null) {
                        type = obj2.toString();
                    }
                }
                catch (ScriptException obj2) {
                    // empty catch block
                }
                if ("undefined".equals(type) || type == null) {
                    js.eval(findNode);
                    js.eval("SCHEME_JSON = " + ConfigService.getSchemeJson());
                    obj2 = js.eval(String.format("findNode(SCHEME_JSON, '%s'.split('.'))['type']", k));
                    if (obj2 != null) {
                        type = obj2.toString();
                    }
                }
                switch (type) {
                    case "string": {
                        jsCode = String.format("allConfig%s = '%s';", jsKey, v);
                        break;
                    }
                    case "number": 
                    case "boolean": 
                    case "undefined": {
                        jsCode = String.format("allConfig%s = %s;", jsKey, v);
                        break;
                    }
                    case "object": {
                        jsCode = String.format("allConfig%s = '%s';", jsKey, v);
                        break;
                    }
                    default: {
                        LOGGER.info("\u672a\u5904\u7406 js \u7c7b\u578b\uff1a " + type);
                    }
                }
            }
            js.eval(jsCode);
        });
        String json = js.eval("JSON.stringify(allConfig, null, 2);", String.class);
        FileHelper.saveText(jsonPath, json);
    }
}

