/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework.config;

import com.ajaxjs.framework.BaseModel;
import com.ajaxjs.framework.IComponent;
import com.ajaxjs.framework.config.SiteStru;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.io.FileHelper;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.util.map.JsonHelper;
import com.ajaxjs.util.map.ListMap;
import com.ajaxjs.util.map.ListMapConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class SiteStruService
implements IComponent {
    private static final LogHelper LOGGER = LogHelper.getLog(SiteStruService.class);
    public static SiteStru STRU;
    public static final Consumer<ServletContext> INITIALIZED;
    private static String TABLE;
    private static String A_LINK;
    private static String NEW_COL;
    private String siteMapCache;

    private static List<Map<String, Object>> db2menu(List<Map<String, Object>> list, final ServletContext cxt) {
        ListMapConfig c = new ListMapConfig();
        c.mapHandler = new ListMapConfig.MapHandler(){

            @Override
            public boolean execute(Map<String, Object> map, Map<String, Object> superMap, int level) {
                if (map.containsKey("dbNode")) {
                    Object _map = cxt.getAttribute(map.get("dbNode").toString());
                    if (_map == null) {
                        LOGGER.warning("Servlet \u521d\u59cb\u5316\u6570\u636e\u672a\u51c6\u5907\u597d\uff0c\u4f9d\u8d56\u6570\u636e\uff1a" + map.get("dbNode").toString());
                        return false;
                    }
                    Map data = (Map)_map;
                    ArrayList list = new ArrayList();
                    for (Long id : data.keySet()) {
                        HashMap<String, String> cMap = new HashMap<String, String>();
                        cMap.put("id", "?catalogId=" + id);
                        cMap.put("name", ((BaseModel)data.get(id)).getName());
                        list.add(cMap);
                    }
                    map.put("children", list);
                }
                return false;
            }
        };
        ListMap.traveler(list, c);
        return list;
    }

    public static void loadSiteStru(ServletContext cxt) {
        SiteStruService.load(cxt);
        if (STRU != null) {
            ListMap.buildPath(STRU, true);
        }
        LOGGER.infoGreen("\u52a0\u8f7d\u7f51\u7ad9\u7684\u7ed3\u6784\u6587\u4ef6\u6210\u529f Site Structure Config Loaded.");
    }

    public static void load(ServletContext ctx) {
        String json = ctx.getRealPath("/META-INF/site_stru.json");
        if (new File(json).exists()) {
            STRU = new SiteStru();
            STRU.setJsonPath(json);
            STRU.setJsonStr(FileHelper.openAsText(json));
            STRU.clear();
            STRU.addAll(SiteStruService.db2menu(JsonHelper.parseList(STRU.getJsonStr()), ctx));
            STRU.setLoaded(true);
        } else {
            LOGGER.info("\u6ca1\u6709\u7f51\u7ad9\u7684\u7ed3\u6784\u6587\u4ef6");
        }
    }

    public List<Map<String, Object>> getNavBar() {
        return STRU;
    }

    public static Map<String, Object> getPageNode(String uri, String contextPath) {
        String path = uri.replace(contextPath, "").replaceAll("/\\d+", "").replaceFirst("/\\w+\\.\\w+$", "");
        if (STRU != null && STRU.isLoaded()) {
            Map<String, Object> map = ListMap.findByPath(path, (List<Map<String, Object>>)STRU);
            return map;
        }
        return null;
    }

    public static Map<String, Object> getPageNode(HttpServletRequest request) {
        return SiteStruService.getPageNode(request.getRequestURI(), request.getContextPath());
    }

    public boolean isCurrentNode(Map<String, ?> node, HttpServletRequest request) {
        if (node == null || node.get("fullPath") == null) {
            return false;
        }
        String uri = request.getRequestURI();
        String contextPath = request.getContextPath();
        String fullPath = node.get("fullPath").toString();
        String ui = contextPath.concat("/").concat(fullPath).concat("/");
        return uri.equals(ui) || uri.indexOf(fullPath) != -1;
    }

    public Map<String, Object> getSecondLevelNode(HttpServletRequest request) {
        if (request.getAttribute("secondLevel_Node") == null) {
            String path = SiteStruService.getPath(request);
            if (CommonUtil.isEmptyString(path)) {
                return null;
            }
            path = path.substring(1, path.length());
            String second = path.split("/")[0];
            Map<String, Object> map = ListMap.findByPath(second, (List<Map<String, Object>>)STRU);
            request.setAttribute("secondLevel_Node", map);
            return map;
        }
        return (Map)request.getAttribute("secondLevel_Node");
    }

    public List<Map<String, Object>> getMenu(HttpServletRequest request) {
        Map<String, Object> map = this.getSecondLevelNode(request);
        return map != null && map.get("children") != null ? (List)map.get("children") : null;
    }

    private static String getPath(HttpServletRequest request) {
        return request.getRequestURI().replace(request.getContextPath(), "").replaceFirst("/\\w+\\.\\w+$", "");
    }

    public String getSiteMap(HttpServletRequest request) {
        if (this.siteMapCache == null) {
            this.siteMapCache = SiteStruService.getSiteMap(STRU, request.getContextPath());
        }
        return this.siteMapCache;
    }

    public static String getSiteMap(List<Map<String, Object>> list, String cxtPath) {
        StringBuilder sb = new StringBuilder();
        SiteStruService.getSiteMap(list, sb, cxtPath);
        return String.format(TABLE, sb.toString());
    }

    private static void getSiteMap(List<Map<String, Object>> list, StringBuilder sb, String cxtPath) {
        for (Map<String, Object> map : list) {
            Object isHidden;
            if (map == null || (isHidden = map.get("isHidden")) != null && ((Boolean)isHidden).booleanValue()) continue;
            if (0 == (Integer)map.get("level")) {
                sb.append(NEW_COL);
            }
            sb.append(String.format(A_LINK, cxtPath + map.get("fullPath").toString(), map.get("level").toString(), map.get("name").toString()));
            if (map.get("children") == null || !(map.get("children") instanceof List)) continue;
            SiteStruService.getSiteMap((List)map.get("children"), sb, cxtPath);
        }
    }

    static {
        INITIALIZED = ctx -> {
            SiteStruService.loadSiteStru(ctx);
            if (STRU != null && STRU.isLoaded()) {
                ctx.setAttribute("SITE_STRU", (Object)new SiteStruService());
            }
        };
        TABLE = "<table class=\"siteMap\"><tr><td>%s</td></tr></table>";
        A_LINK = "<a href=\"%s/\" class=\"indentBlock_%s\"><span class=\"dot\">\u00b7</span>%s</a>\n ";
        NEW_COL = "\n\t</td>\n\t<td>\n\t\t";
    }
}

