/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework.config;

import com.ajaxjs.framework.config.SiteStruService;
import com.ajaxjs.util.CommonUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class SiteStruTag
extends SimpleTagSupport {
    private String type;
    private static final String LI = "<li%s><a href=\"%s/\">%s</a></li>";
    private static final String LI_NO_END = "<li%s><a href=\"%s\">%s</a></li>";
    private static final String LI_EXT = "<li%s><a href=\"%s/\">%s</a><ul>%s</ul></li></li>";

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        SiteStruService sitestru = (SiteStruService)pageContext.getServletContext().getAttribute("SITE_STRU");
        if (sitestru == null) {
            throw new UnsupportedOperationException(" \u672a \u5b9a\u4e49 SiteStruService \u7c7b\u578b\u7684 SITE_STRU\uff0c\u8be5\u5e38\u91cf\u5e94\u5728 Servlet \u521d\u59cb\u5316\u65f6\u5b9a\u4e49\u3002");
        }
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String output = "Error Type for tag : ";
        switch (this.type) {
            case "navBar": {
                output = SiteStruTag.buildNavBar(sitestru, request);
                break;
            }
            case "secondLevelMenu": {
                if (request.getAttribute("PAGE_Node") == null) break;
                output = SiteStruTag.buildSecondLevelMenu(sitestru, request);
                break;
            }
            case "subMenu": {
                if (request.getAttribute("PAGE_Node") == null) break;
                output = SiteStruTag.buildSubMenu(sitestru, request);
                break;
            }
            case "breadCrumb": {
                output = SiteStruTag.buildBreadCrumb(sitestru, request);
                break;
            }
            default: {
                output = output + this.type;
            }
        }
        pageContext.getOut().write(output);
    }

    private static String buildNavBar(SiteStruService sitestru, HttpServletRequest request) {
        Iterator<Map<String, Object>> _showNavSubMenuUl;
        String ctx = request.getContextPath();
        StringBuilder sb = new StringBuilder();
        boolean hasSelected = false;
        Object _customNavLi = request.getAttribute("customNavLi");
        boolean showNavSubMenu = request.getAttribute("showNavSubMenu") != null && (Boolean)request.getAttribute("showNavSubMenu") != false;
        boolean customSubMenu = false;
        String showNavSubMenuUl = null;
        String showNavSubMenuLi = null;
        if (showNavSubMenu && (_showNavSubMenuUl = request.getAttribute("showNavSubMenuUl")) != null) {
            customSubMenu = true;
            showNavSubMenuUl = (String)((Object)_showNavSubMenuUl);
            showNavSubMenuLi = (String)request.getAttribute("showNavSubMenuLi");
        }
        if (sitestru.getNavBar() != null) {
            for (Map<String, Object> item : sitestru.getNavBar()) {
                Object isHidden = item.get("isHidden");
                if (isHidden != null && ((Boolean)isHidden).booleanValue()) continue;
                boolean isSelected = sitestru.isCurrentNode(item, request);
                String url = ctx + "/" + item.get("id");
                url = SiteStruTag.addParam(url, item);
                if (_customNavLi == null) {
                    sb.append(String.format(LI, isSelected ? " class=\"selected\"" : "", url, item.get("name")));
                } else {
                    String _li = _customNavLi.toString();
                    if (isSelected) {
                        _li = _li.replace("class=\"", "class=\"selected ");
                    }
                    if (showNavSubMenu) {
                        if (customSubMenu) {
                            sb.append(String.format(_li, url, item.get("name"), SiteStruTag.buildSubMenu(showNavSubMenuUl, showNavSubMenuLi, item, ctx)));
                        }
                    } else {
                        sb.append(String.format(_li, url, item.get("name")));
                    }
                }
                if (!isSelected) continue;
                hasSelected = true;
            }
        }
        if (_customNavLi == null) {
            return String.format(LI, !hasSelected ? " class=\"home selected\"" : " class=\"home\"", "".equals(ctx) ? "" : ctx, "\u9996\u9875") + sb.toString();
        }
        String _li = _customNavLi.toString();
        if (showNavSubMenu) {
            return String.format(_li.replace("class=\"", "class=\"home "), "".equals(ctx) ? "/" : ctx, "\u9996\u9875", "") + sb.toString();
        }
        return String.format(_li.replace("class=\"", "class=\"home "), "".equals(ctx) ? "/" : ctx, "\u9996\u9875") + sb.toString();
    }

    private static String buildSubMenu(String showNavSubMenuUl, String showNavSubMenuLi, Map<String, Object> item, String ctx) {
        StringBuilder sb = new StringBuilder();
        List menu = (List)item.get("children");
        for (Map m : menu) {
            String url = ctx + m.get("fullPath").toString();
            sb.append(String.format(showNavSubMenuLi, url, m.get("name").toString()));
        }
        return String.format(showNavSubMenuUl, sb.toString());
    }

    private static String addParam(String url, Map<String, Object> item) {
        Object param = item.get("param");
        if (param != null) {
            url = url + (String)param;
        }
        return url;
    }

    private static String buildSubMenu(SiteStruService sitestru, HttpServletRequest request) {
        String ctx = request.getContextPath();
        StringBuilder sb = new StringBuilder();
        Map node = (Map)request.getAttribute("PAGE_Node");
        List nodes = (List)node.get("children");
        for (Map item : nodes) {
            Object isHidden = item.get("isHidden");
            if (isHidden != null && ((Boolean)isHidden).booleanValue()) continue;
            String url = ctx + item.get("fullPath");
            url = SiteStruTag.addParam(url, item);
            boolean isSelected = sitestru.isCurrentNode(item, request);
            sb.append(String.format(LI, isSelected ? " class=\"selected\"" : "", url, item.get("name")));
        }
        return sb.toString();
    }

    private static String buildSecondLevelMenu(SiteStruService sitestru, HttpServletRequest request) {
        String ctx = request.getContextPath();
        StringBuilder sb = new StringBuilder();
        if (sitestru.getMenu(request) != null) {
            boolean showSubMenu = request.getAttribute("showSubMenu") != null;
            for (Map<String, Object> item : sitestru.getMenu(request)) {
                Object isHidden = item.get("isHidden");
                if (isHidden != null && ((Boolean)isHidden).booleanValue()) continue;
                String url = ctx + item.get("fullPath");
                url = SiteStruTag.addParam(url, item);
                boolean isSelected = sitestru.isCurrentNode(item, request);
                if (showSubMenu) {
                    StringBuilder subMenu = new StringBuilder();
                    List menu = (List)item.get("children");
                    if (!CommonUtil.isNull(menu)) {
                        for (Map m : menu) {
                            String _url = ctx + m.get("fullPath").toString();
                            subMenu.append(String.format(LI, "", _url, "\u00bb " + m.get("name").toString()));
                        }
                    }
                    sb.append(String.format(LI_EXT, isSelected ? " class=\"selected\"" : "", url, item.get("name"), subMenu.toString()));
                    continue;
                }
                sb.append(String.format(url.indexOf("?") != -1 ? LI_NO_END : LI, isSelected ? " class=\"selected\"" : "", url, item.get("name")));
            }
        }
        return sb.toString();
    }

    private static String buildBreadCrumb(SiteStruService sitestru, HttpServletRequest request) {
        String ctx = request.getContextPath();
        String uri = request.getRequestURI();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<nav class=\"anchor\">\u60a8\u7684\u4f4d\u7f6e \uff1a<a href=\"%s\">\u9996 \u9875 </a>", ctx));
        Object obj = request.getAttribute("PAGE_Node");
        if (obj == null && !uri.equals(request.getContextPath() + "/") && uri.indexOf(ctx + "/index") == -1) {
            System.err.println("\u4e0d\u80fd\u6e32\u67d3\u5bfc\u822a\u5b9a\u4f4d\uff0c\u8be5\u9875\u9762\u53ef\u80fd\uff1a1\u3001\u672a\u5f15\u7528 head.jsp \u521b\u5efa NODE \u8282\u70b9\uff1b2\u3001\u672a\u5b9a\u4e49\u8be5\u8def\u5f84\u4e4b\u8bf4\u660e\u3002");
            return "";
        }
        Map node = (Map)obj;
        String tpl = " \u00bb <a href=\"%s\">%s</a>";
        if ((node != null || uri.indexOf(ctx + "/index") == -1) && node != null) {
            if (node.get("supers") != null) {
                String[] supers;
                String _supers = (String)node.get("supers");
                for (String _super : supers = _supers.split(",")) {
                    Object[] arr = _super.split(":");
                    if (CommonUtil.isNull(arr) || arr.length < 2) continue;
                    sb.append(String.format(tpl, ctx + (String)arr[0], arr[1]));
                }
            }
            sb.append(String.format(tpl, ctx + node.get("fullPath"), node.get("name")));
        }
        sb.append("</nav>");
        return sb.toString();
    }
}

