/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.framework.filter;

import com.ajaxjs.framework.config.ConfigService;
import com.ajaxjs.net.http.NetUtil;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.map.JsonHelper;
import com.ajaxjs.web.mvc.filter.FilterAction;
import com.ajaxjs.web.mvc.filter.FilterAfterArgs;
import com.ajaxjs.web.mvc.filter.FilterContext;
import java.util.Map;

public class CaptchaFilter
implements FilterAction {
    private static final String PARAM_NAME = "grecaptchaToken";
    private static final String SITE_VERIFY = "https://www.recaptcha.net/recaptcha/api/siteverify";
    private static final String PARAMS = "secret=%s&response=%s";

    @Override
    public boolean before(FilterContext ctx) {
        if (ConfigService.getBol("security.disableCaptcha")) {
            return true;
        }
        String token = ctx.request.getParameter(PARAM_NAME);
        if (CommonUtil.isEmptyString(token)) {
            throw new IllegalArgumentException("\u975e\u6cd5\u653b\u51fb\uff01\u5ba2\u6237\u7aef\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570 ");
        }
        token = token.trim();
        String secret = ConfigService.get("security.GoogleReCAPTCHA.secret");
        String params = String.format(PARAMS, secret, token);
        String json = NetUtil.post(SITE_VERIFY, params);
        if (CommonUtil.isEmptyString(json)) {
            throw new IllegalAccessError("\u8c37\u6b4c\u9a8c\u8bc1\u7801\u670d\u52a1\u5931\u6548\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458");
        }
        Map<String, Object> map = JsonHelper.parseMap(json);
        if (map == null) {
            throw new IllegalAccessError("\u8c37\u6b4c\u9a8c\u8bc1\u7801\u670d\u52a1\u5931\u6548\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458");
        }
        if (((Boolean)map.get("success")).booleanValue()) {
            return true;
        }
        ctx.model.put("NOT_LOG_EXCEPTION", true);
        if ("timeout-or-duplicate".equals(map.get("error-codes").toString())) {
            throw new NullPointerException("\u9a8c\u8bc1\u7801\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0");
        }
        throw new IllegalAccessError("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
    }

    @Override
    public boolean after(FilterAfterArgs args) {
        return true;
    }
}

