/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.jsonparser;

import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.io.FileHelper;
import com.ajaxjs.util.io.StreamHelper;
import com.ajaxjs.util.logger.LogHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JsEngineWrapper {
    private static final LogHelper LOGGER = LogHelper.getLog(JsEngineWrapper.class);
    private ScriptEngine engine;

    public JsEngineWrapper() {
        this(JsEngineWrapper.engineFactory());
    }

    public JsEngineWrapper(ScriptEngine engine) {
        this.engine = engine;
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    public void setEngine(ScriptEngine engine) {
        this.engine = engine;
    }

    public static ScriptEngine engineFactory() {
        return new ScriptEngineManager().getEngineByName(System.getProperty("java.version").contains("1.8.") ? "nashorn" : "rhino");
    }

    public JsEngineWrapper load(String path) {
        LOGGER.info("\u52a0\u8f7d js: {0} \u6587\u4ef6", path);
        this.eval(FileHelper.openAsText(path));
        return this;
    }

    public JsEngineWrapper load(Class<?> clazz, String fileName) {
        String code = null;
        try (InputStream in = clazz.getResourceAsStream(fileName);){
            code = StreamHelper.byteStream2string(in);
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
        if (code != null) {
            this.eval(code);
        }
        return this;
    }

    public <T> T call(String method, Class<T> clazz, Object binding, Object ... args) {
        Invocable inv = (Invocable)((Object)this.engine);
        Object result = null;
        try {
            result = binding != null ? inv.invokeMethod(binding, method, args) : inv.invokeFunction(method, args);
        }
        catch (NoSuchMethodException e) {
            LOGGER.warning(e, "\u811a\u672c\u5f15\u64ce\u6ca1\u6709 {0}() \u8fd9\u4e2a\u65b9\u6cd5", method);
        }
        catch (ScriptException e) {
            LOGGER.warning(e, "\u5411\u811a\u672c\u5f15\u64ce\u8c03\u7528\u811a\u672c\u65b9\u6cd5\u5f02\u5e38\uff01\u65b9\u6cd5\u540d\u79f0:" + method);
        }
        return (T)(result == null ? null : result);
    }

    public void put(String varName, Object obj) {
        this.engine.put(varName, obj);
    }

    public Object get(String ... namespace) {
        Map obj = (Map)this.engine.get(namespace[0]);
        for (int i = 1; i < namespace.length; ++i) {
            try {
                obj = (Map)obj.get(namespace[i]);
                continue;
            }
            catch (ClassCastException e) {
                return obj.get(namespace[i]);
            }
        }
        return obj;
    }

    public <T> T eval(String code, Class<T> clazz) {
        if (CommonUtil.isEmptyString(code)) {
            throw new UnsupportedOperationException("JS \u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Object obj = null;
        try {
            obj = this.engine.eval(code);
        }
        catch (ScriptException e) {
            LOGGER.warning(e, "\u811a\u672c eval() \u8fd0\u7b97\u53d1\u751f\u5f02\u5e38\uff01eval \u4ee3\u7801\uff1a" + code);
        }
        if (obj != null && clazz != null) {
            return (T)obj;
        }
        return null;
    }

    public Object eval(String code) {
        return this.eval(code, Object.class);
    }
}

