/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.jsonparser.lexer;

import com.ajaxjs.jsonparser.JsonParseException;
import com.ajaxjs.jsonparser.lexer.BaseLexer;
import com.ajaxjs.jsonparser.lexer.NumberToken;
import com.ajaxjs.jsonparser.lexer.StringToken;
import com.ajaxjs.jsonparser.lexer.Token;
import com.ajaxjs.jsonparser.lexer.Tokens;
import java.util.Stack;

public class Lexer
extends BaseLexer {
    private int lineNum;
    private Stack<Integer> colMarks = new Stack();
    private int startLine;
    private int startCol;
    private int cur = -1;
    private String str;
    private int len;

    public Lexer(String str) {
        this.str = str;
        this.len = str.length();
        this.startLine = 0;
        this.startCol = 0;
        this.cur = -1;
        this.lineNum = 0;
        this.colMarks.push(0);
    }

    public char getCurChar() {
        return this.cur >= this.len - 1 ? (char)'\u0000' : this.str.charAt(this.cur);
    }

    private void checkEnd() {
        if (this.cur >= this.len - 1) {
            throw this.exceptionFactory("\u672a\u9884\u671f\u7684\u7ed3\u675f\uff0c\u5b57\u7b26\u4e32\u672a\u7ed3\u675f");
        }
    }

    public Token next() {
        char c;
        if (this.lineNum == 0) {
            this.lineNum = 1;
            return Tokens.BGN;
        }
        while ((c = this.nextChar()) != '\u0000') {
            this.startLine = this.lineNum;
            this.startCol = this.getColNum();
            if (c == '\"' || c == '\'') {
                return new StringToken(this.getStrValue(c));
            }
            if (Lexer.isLetterUnderline(c)) {
                return this.getValueToken();
            }
            if (Lexer.isNum(c) || c == '-') {
                return new NumberToken(this.getNumValue());
            }
            if (Lexer.isSpace(c)) continue;
            return this.parseSymbol(c);
        }
        if (c == '\u0000') {
            return Tokens.EOF;
        }
        return null;
    }

    private String getStrValue(char s) {
        char c;
        int start = this.cur;
        while ((c = this.nextChar()) != '\u0000') {
            if (c == '\\') {
                c = this.nextChar();
                continue;
            }
            if (s != c) continue;
            return this.str.substring(start + 1, this.cur);
        }
        this.checkEnd();
        return null;
    }

    private String getNumValue() {
        char c;
        int start = this.cur;
        while ((c = this.nextChar()) != '\u0000') {
            if (Lexer.isDecimal(c)) continue;
            return this.str.substring(start, this.revertChar());
        }
        this.checkEnd();
        return null;
    }

    private Token getValueToken() {
        char c;
        int start = this.cur;
        while ((c = this.nextChar()) != '\u0000') {
            if (Lexer.isNumLetterUnderline(c)) continue;
            String value = this.str.substring(start, this.revertChar());
            if ("true".equals(value)) {
                return Tokens.TRUE;
            }
            if ("false".equals(value)) {
                return Tokens.FALSE;
            }
            if ("null".equals(value)) {
                return Tokens.NIL;
            }
            return new StringToken(value);
        }
        this.checkEnd();
        return null;
    }

    private Token parseSymbol(char c) {
        switch (c) {
            case '[': {
                return Tokens.ARRS;
            }
            case ']': {
                return Tokens.ARRE;
            }
            case '{': {
                return Tokens.OBJS;
            }
            case '}': {
                return Tokens.OBJE;
            }
            case ',': {
                return Tokens.SPLIT;
            }
            case ':': {
                return Tokens.DESC;
            }
        }
        return null;
    }

    private char nextChar() {
        if (this.cur >= this.len - 1) {
            return '\u0000';
        }
        ++this.cur;
        char c = this.str.charAt(this.cur);
        if (c == '\n') {
            ++this.lineNum;
            this.colMarks.push(this.cur);
        }
        return c;
    }

    private int revertChar() {
        int rcur;
        if (this.cur <= 0) {
            return 0;
        }
        if (this.str.charAt(rcur = this.cur--) == '\n') {
            --this.lineNum;
            this.colMarks.pop();
        }
        return rcur;
    }

    public JsonParseException exceptionFactory(String msg) {
        return new JsonParseException(this.cur, this.startLine, this.startCol, msg);
    }

    public JsonParseException exceptionFactory(String msg, Throwable e) {
        return new JsonParseException(this.cur, this.startLine, this.startCol, msg, e);
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public int getColNum() {
        return this.cur - this.colMarks.peek();
    }

    public int getCur() {
        return this.cur;
    }

    public String getStr() {
        return this.str;
    }

    public int getLen() {
        return this.len;
    }
}

