/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.jsonparser.lexer;

import com.ajaxjs.jsonparser.JsonParseException;
import com.ajaxjs.jsonparser.lexer.Token;

public class StringToken
extends Token {
    public StringToken(String value) {
        super(0, "STR", "\u5b57\u7b26\u4e32", null, value);
    }

    public static String unescape(String str) {
        StringBuilder sb = new StringBuilder();
        block11: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                c = str.charAt(++i);
                switch (c) {
                    case '\"': {
                        sb.append('\"');
                        continue block11;
                    }
                    case '\\': {
                        sb.append('\\');
                        continue block11;
                    }
                    case '/': {
                        sb.append('/');
                        continue block11;
                    }
                    case 'b': {
                        sb.append('\b');
                        continue block11;
                    }
                    case 'f': {
                        sb.append('\f');
                        continue block11;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block11;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block11;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block11;
                    }
                    case 'u': {
                        String hex = str.substring(i + 1, i + 5);
                        sb.append((char)Integer.parseInt(hex, 16));
                        i += 4;
                        continue block11;
                    }
                    default: {
                        throw new JsonParseException("\u201c\\\u201d\u540e\u9762\u671f\u5f85\u201c\"\\/bfnrtu\u201d\u4e2d\u7684\u5b57\u7b26\uff0c\u7ed3\u679c\u5f97\u5230\u201c" + c + "\u201d");
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

