/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.jsonparser.syntax;

import com.ajaxjs.jsonparser.JsonParseException;
import com.ajaxjs.jsonparser.lexer.Lexer;
import com.ajaxjs.jsonparser.lexer.Token;
import com.ajaxjs.jsonparser.lexer.Tokens;
import com.ajaxjs.jsonparser.syntax.Operator;
import com.ajaxjs.jsonparser.syntax.State;
import com.ajaxjs.jsonparser.syntax.States;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

public class FMS
implements States {
    private Lexer lex;
    private Operator opt;
    private State status;
    private static final String strTpl = "\u5f53\u524d\u72b6\u6001\u3010 %s \u3011, \u671f\u5f85\u3010 %s \u3011; \u4f46\u5374\u8fd4\u56de %s";
    private static final Method[] TKOL = new Method[]{null, null, null, null, Operator.getMethod("arrs"), Operator.getMethod("objs"), null, null, null, null, null, null};
    static final String[] allText = new String[]{"\u5b57\u7b26\u4e32", "\u6570\u5b57", Tokens.DESC.getTypeNameChinese(), Tokens.SPLIT.getTypeNameChinese(), Tokens.ARRS.getTypeNameChinese(), Tokens.OBJS.getTypeNameChinese(), Tokens.ARRE.getTypeNameChinese(), Tokens.OBJE.getTypeNameChinese(), Tokens.FALSE.getTypeNameChinese(), Tokens.TRUE.getTypeNameChinese(), Tokens.NIL.getTypeNameChinese(), Tokens.BGN.getTypeNameChinese()};
    static final String[] ETS = new String[]{FMS.getExpectStr(BGN.getId()), FMS.getExpectStr(ARRBV.getId()), FMS.getExpectStr(ARRAV.getId()), FMS.getExpectStr(OBJBK.getId()), FMS.getExpectStr(OBJAK.getId()), FMS.getExpectStr(OBJBV.getId()), FMS.getExpectStr(OBJAV.getId()), Tokens.EOF.getTypeNameChinese(), Tokens.EOF.getTypeNameChinese(), Tokens.EOF.getTypeNameChinese()};

    public FMS(String json) {
        Objects.requireNonNull(json, "\u6ca1\u6709\u8f93\u5165\u7684 JSON \u5b57\u7b26\u4e32\u3002");
        this.lex = new Lexer(json);
        this.opt = new Operator(this.lex);
    }

    public Object parse() {
        Token tk;
        State oldStatus = this.status = BGN;
        while ((tk = this.lex.next()) != Tokens.EOF) {
            if (tk == null) {
                throw this.lex.exceptionFactory("\u53d1\u73b0\u4e0d\u80fd\u8bc6\u522b\u7684 token\uff1a" + this.lex.getCurChar());
            }
            if (this.status == VAL || this.status == EOF || this.status == ERR) {
                throw this.lex.exceptionFactory(String.format(strTpl, oldStatus.getDescription(), "\u7ed3\u675f", tk.toString()));
            }
            oldStatus = this.status;
            this.status = states[oldStatus.getId()][tk.getType()];
            if (this.status == ERR) {
                String expectStr = ETS[oldStatus.getId()];
                throw this.lex.exceptionFactory(String.format(strTpl, oldStatus.getDescription(), expectStr, tk.toString()));
            }
            Method m = TKOL[tk.getType()];
            try {
                if (m != null) {
                    this.status = (State)m.invoke((Object)this.opt, oldStatus, this.status, tk);
                }
                if ((m = this.status.getHandler()) == null) continue;
                this.status = (State)m.invoke((Object)this.opt, oldStatus, this.status, tk);
            }
            catch (IllegalArgumentException e) {
                throw this.lex.exceptionFactory("\u3010\u53cd\u5c04\u8c03\u7528\u3011\u4f20\u5165\u975e\u6cd5\u53c2\u6570", e);
            }
            catch (IllegalAccessException e) {
                throw this.lex.exceptionFactory("\u3010\u53cd\u5c04\u8c03\u7528\u3011\u79c1\u6709\u65b9\u6cd5\u65e0\u6cd5\u8c03\u7528", e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof JsonParseException) {
                    throw (JsonParseException)e.getTargetException();
                }
                throw this.lex.exceptionFactory("\u8fd0\u884c\u65f6\u5f02\u5e38", e);
            }
        }
        return this.opt.getCurValue();
    }

    static String getExpectStr(int stateId) {
        State[] stateArr = States.states[stateId];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stateArr.length; ++i) {
            State s = stateArr[i];
            if (s == ERR) continue;
            sb.append(allText[i]).append('|');
        }
        return sb.length() == 0 ? null : sb.deleteCharAt(sb.length() - 1).toString();
    }
}

