/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.jsonparser.syntax;

import com.ajaxjs.jsonparser.JsonParseException;
import com.ajaxjs.jsonparser.lexer.Lexer;
import com.ajaxjs.jsonparser.lexer.NumberToken;
import com.ajaxjs.jsonparser.lexer.StringToken;
import com.ajaxjs.jsonparser.lexer.Token;
import com.ajaxjs.jsonparser.lexer.Tokens;
import com.ajaxjs.jsonparser.syntax.FMS;
import com.ajaxjs.jsonparser.syntax.State;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Operator {
    private Lexer lex;
    private Object curObj;
    private Object curValue;
    private Stack<State> statusStack = new Stack();
    private Stack<Object> keyStack = new Stack();
    private Stack<Object> objStack = new Stack();

    public Operator(Lexer lex) {
        this.lex = lex;
    }

    public State objs(State from, State to, Token input) {
        if (from != FMS.BGN) {
            this.statusStack.push(from);
        }
        this.curObj = new HashMap();
        this.objStack.push(this.curObj);
        return to;
    }

    public State arrs(State from, State to, Token input) {
        if (from != FMS.BGN) {
            this.statusStack.push(from);
        }
        this.curObj = new ArrayList();
        this.objStack.push(this.curObj);
        return to;
    }

    public State val(State from, State to, Token input) {
        if (input == Tokens.ARRE || input == Tokens.OBJE) {
            this.curValue = this.curObj = this.objStack.pop();
        } else if (input == Tokens.TRUE || input == Tokens.FALSE || input == Tokens.NIL || input.getType() == 0 || input.getType() == 1) {
            this.curValue = this.getRealValue(input);
        }
        if (this.statusStack.isEmpty()) {
            return FMS.EOF;
        }
        State s = this.statusStack.pop();
        if (s == FMS.ARRBV) {
            this.curObj = this.objStack.peek();
            ((List)this.curObj).add(this.curValue);
            s = FMS.ARRAV;
        } else if (s == FMS.OBJBV) {
            this.curObj = this.objStack.peek();
            ((Map)this.curObj).put(this.keyStack.pop(), this.curValue);
            s = FMS.OBJAV;
        }
        return s;
    }

    public State objak(State from, State to, Token input) {
        this.keyStack.push(this.getRealValue(input));
        return to;
    }

    public State arrav(State from, State to, Token input) {
        this.curValue = this.getRealValue(input);
        ((List)this.curObj).add(this.curValue);
        return to;
    }

    public State objav(State from, State to, Token input) {
        this.curValue = this.getRealValue(input);
        ((Map)this.curObj).put(this.keyStack.pop(), this.curValue);
        return to;
    }

    private Object getRealValue(Token token) {
        try {
            if (token == Tokens.TRUE || token == Tokens.FALSE || token == Tokens.NIL) {
                return token.getJavaValue();
            }
            if (token instanceof StringToken) {
                return StringToken.unescape(token.getValue());
            }
            if (token instanceof NumberToken) {
                if (token.getValue().indexOf(46) != -1) {
                    return Double.parseDouble(token.getValue());
                }
                return Integer.parseInt(token.getValue());
            }
            throw new JsonParseException("\u83b7\u53d6 Java \u503c\u5931\u8d25\uff01");
        }
        catch (RuntimeException e) {
            this.lex.exceptionFactory("\u5b57\u7b26\u4e32\u8f6c\u6362\u9519\u8bef", e);
            return null;
        }
    }

    static Method getMethod(String methodName) {
        try {
            return Operator.class.getMethod(methodName, State.class, State.class, Token.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getCurObj() {
        return this.curObj;
    }

    public Object getCurValue() {
        return this.curValue;
    }
}

