/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.net.http;

import com.ajaxjs.util.Encode;
import com.ajaxjs.util.io.StreamHelper;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.util.map.MapTool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;

public class HttpBasicRequest
extends StreamHelper {
    private static final LogHelper LOGGER = LogHelper.getLog(HttpBasicRequest.class);
    public static final BiConsumer<HttpURLConnection, String> setMedthod = (conn, method) -> {
        try {
            conn.setRequestMethod((String)method);
        }
        catch (ProtocolException e) {
            LOGGER.warning(e);
        }
    };
    public static final BiConsumer<HttpURLConnection, Map<String, String>> setCookies = (conn, map) -> conn.addRequestProperty("Cookie", MapTool.join(map, ";"));
    public static final BiConsumer<HttpURLConnection, String> setReferer = (conn, url) -> conn.addRequestProperty("Referer", (String)url);
    public static final BiConsumer<HttpURLConnection, Integer> setTimeout = (conn, timeout) -> conn.setConnectTimeout(timeout * 1000);
    public static final BiConsumer<HttpURLConnection, String> setUserAgent = (conn, url) -> conn.addRequestProperty("User-Agent", (String)url);
    public static final Consumer<HttpURLConnection> setUserAgentDefault = conn -> setUserAgent.accept((HttpURLConnection)conn, "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
    public static final Consumer<HttpURLConnection> setGizpRequest = conn -> conn.addRequestProperty("Accept-Encoding", "gzip, deflate");
    public static final Consumer<HttpURLConnection> setFormPost = conn -> conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded;charset=utf-8");

    public static HttpURLConnection initHttpConnection(String url) {
        URL httpUrl = null;
        try {
            httpUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            LOGGER.warning(e, "\u521d\u59cb\u5316\u8fde\u63a5\u51fa\u9519\uff01URL[{0}]\u683c\u5f0f\u4e0d\u5bf9\uff01", url);
        }
        try {
            return (HttpURLConnection)httpUrl.openConnection();
        }
        catch (IOException e) {
            LOGGER.warning(e, "\u521d\u59cb\u5316\u8fde\u63a5\u51fa\u9519\uff01URL[{0}]\u3002", url);
            return null;
        }
    }

    public static <T> T getResponse(HttpURLConnection conn, Boolean isEnableGzip, Function<InputStream, T> callback) {
        try {
            int responseCode;
            boolean isGzip;
            InputStream in = conn.getInputStream();
            boolean bl = isGzip = isEnableGzip != false || "gzip".equals(conn.getHeaderField("Content-Encoding"));
            if (isGzip) {
                in = new GZIPInputStream(in);
            }
            if ((responseCode = conn.getResponseCode()) >= 400) {
                RuntimeException e = new RuntimeException(responseCode < 500 ? responseCode + "\uff1a\u5ba2\u6237\u7aef\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff01" : responseCode + "\uff1a\u62b1\u6b49\uff01\u6211\u4eec\u670d\u52a1\u7aef\u51fa\u9519\u4e86\uff01");
                LOGGER.warning(e);
            }
            if (callback != null) {
                return callback.apply(in);
            }
            in.close();
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
        return null;
    }

    public static String simpleGET(String url) {
        try {
            return HttpBasicRequest.byteStream2string(new URL(url).openStream());
        }
        catch (IOException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static String get(String url) {
        return HttpBasicRequest.get(url, false);
    }

    public static String get(String url, boolean isGzip) {
        return HttpBasicRequest.get(url, isGzip, null);
    }

    public static String get(String url, boolean isGzip, Consumer<HttpURLConnection> fn) {
        HttpURLConnection conn = HttpBasicRequest.initHttpConnection(url);
        if (isGzip) {
            setGizpRequest.accept(conn);
        }
        if (fn != null) {
            fn.accept(conn);
        }
        return HttpBasicRequest.getResponse(conn, isGzip, StreamHelper::byteStream2string);
    }

    public static String post(String url, Map<String, Object> data) {
        if (data != null && data.size() > 0) {
            return HttpBasicRequest.post(url, MapTool.join(data, v -> v == null ? null : Encode.urlEncode(v.toString())));
        }
        return null;
    }

    public static String post(String url, String params) {
        return HttpBasicRequest.post(url, params.getBytes(), null);
    }

    public static String post(String url, byte[] b, Consumer<HttpURLConnection> fn) {
        return HttpBasicRequest.post(url, b, fn, null);
    }

    public static String post(String url, String params, Consumer<HttpURLConnection> fn) {
        return HttpBasicRequest.post(url, params.getBytes(), fn);
    }

    public static String post(String url, byte[] b, Consumer<HttpURLConnection> fn, Function<InputStream, String> responseHandler) {
        HttpURLConnection conn = HttpBasicRequest.initHttpConnection(url);
        setMedthod.accept(conn, "POST");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        if (fn != null) {
            fn.accept(conn);
        } else {
            setFormPost.accept(conn);
        }
        try (OutputStream out = conn.getOutputStream();){
            out.write(b);
            out.flush();
        }
        catch (IOException e) {
            LOGGER.warning("\u5199\u5165 post \u6570\u636e\u65f6\u5931\u8d25\uff01[{0}]", e);
        }
        return HttpBasicRequest.getResponse(conn, false, responseHandler == null ? StreamHelper::byteStream2string : responseHandler);
    }

    public static String put(String url, byte[] b, Consumer<HttpURLConnection> fn, Function<InputStream, String> responseHandler) {
        HttpURLConnection conn = HttpBasicRequest.initHttpConnection(url);
        setMedthod.accept(conn, "PUT");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        if (fn != null) {
            fn.accept(conn);
        } else {
            setFormPost.accept(conn);
        }
        try (OutputStream out = conn.getOutputStream();){
            out.write(b);
            out.flush();
        }
        catch (IOException e) {
            LOGGER.warning("\u5199\u5165 post \u6570\u636e\u65f6\u5931\u8d25\uff01[{0}]", e);
        }
        return HttpBasicRequest.getResponse(conn, false, responseHandler == null ? StreamHelper::byteStream2string : responseHandler);
    }

    public static String delete(String url, Consumer<HttpURLConnection> fn, Function<InputStream, String> responseHandler) {
        HttpURLConnection conn = HttpBasicRequest.initHttpConnection(url);
        setMedthod.accept(conn, "DELETE");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        if (fn != null) {
            fn.accept(conn);
        }
        return HttpBasicRequest.getResponse(conn, false, responseHandler == null ? StreamHelper::byteStream2string : responseHandler);
    }
}

