/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.net.http;

import com.ajaxjs.net.http.HttpBasicRequest;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.Encode;
import com.ajaxjs.util.io.FileHelper;
import com.ajaxjs.util.io.StreamHelper;
import com.ajaxjs.util.logger.LogHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class NetUtil
extends HttpBasicRequest {
    private static final LogHelper LOGGER = LogHelper.getLog(NetUtil.class);
    public static final BiConsumer<HttpURLConnection, String[]> setBasicAuth = (conn, auth) -> {
        String username = auth[0];
        String password = auth[1];
        String encoding = Encode.base64Encode(username + ":" + password);
        conn.setRequestProperty("Authorization", "Basic " + encoding);
    };
    private static final String divField = "\r\n--%s\r\nContent-Disposition: form-data; name=\"%s\"\r\n\r\n%s";
    private static final String newLine = "\r\n";
    private static final String boundaryPrefix = "--";
    public static String BOUNDARY = "------------7d4a6d158c9";
    private static String str = "--" + BOUNDARY + "\r\n" + "Content-Disposition: form-data;name=\"%s\";filename=\"%s\"" + "\r\n" + "Content-Type:%s" + "\r\n" + "\r\n";
    private static byte[] endData = ("\r\n--" + BOUNDARY + "--" + "\r\n").getBytes();

    public static HttpURLConnection head(String url) {
        HttpURLConnection conn = NetUtil.initHttpConnection(url);
        setMedthod.accept(conn, "HEAD");
        conn.setInstanceFollowRedirects(false);
        NetUtil.getResponse(conn, false, null);
        return conn;
    }

    public static String get302redirect(String url) {
        return NetUtil.head(url).getHeaderField("Location");
    }

    public static boolean is404(String url) {
        try {
            return NetUtil.head(url).getResponseCode() == 404;
        }
        catch (IOException e) {
            LOGGER.warning(e);
            return false;
        }
    }

    public static long getFileSize(String url) {
        return NetUtil.head(url).getContentLength();
    }

    public static Function<InputStream, String> initDownload2disk_Callback(String saveDir, String fileName) {
        return in -> {
            File file = FileHelper.createFile(saveDir, fileName);
            try {
                String string;
                Throwable throwable;
                FileOutputStream out;
                block23: {
                    block24: {
                        out = new FileOutputStream(file);
                        throwable = null;
                        NetUtil.write(in, out, true);
                        LOGGER.info("\u6587\u4ef6 [{0}]\u5199\u5165\u6210\u529f", file.toString());
                        string = file.toString();
                        if (out == null) break block23;
                        if (throwable == null) break block24;
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block23;
                    }
                    ((OutputStream)out).close();
                }
                return string;
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (out != null) {
                                if (throwable != null) {
                                    try {
                                        ((OutputStream)out).close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    ((OutputStream)out).close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warning(e);
                    }
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.warning(e);
                }
            }
            return null;
        };
    }

    public static String download(String url, String saveDir, String newFileName) {
        HttpURLConnection conn = NetUtil.initHttpConnection(url);
        setUserAgentDefault.accept(conn);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        String fileName = FileHelper.getFileNameFromUrl(url);
        if (newFileName != null) {
            fileName = newFileName + CommonUtil.regMatch("\\.\\w+$", fileName);
        }
        String newlyFilePath = NetUtil.getResponse(conn, false, NetUtil.initDownload2disk_Callback(saveDir, fileName));
        return newlyFilePath;
    }

    public static String download(String url, String saveDir) {
        return NetUtil.download(url, saveDir, null);
    }

    public static String postDownload(String url, Map<String, Object> data, String saveDir, String fileName) {
        if (data != null && data.size() > 0) {
            return NetUtil.post(url, "{\"path\":\"pages/index/index\"}".getBytes(), null, NetUtil.initDownload2disk_Callback(saveDir, fileName));
        }
        return null;
    }

    public static byte[] toFromData(Map<String, Object> data) {
        byte[] bytes = null;
        for (String key : data.keySet()) {
            byte[] _bytes;
            Object v = data.get(key);
            if (v instanceof File) {
                File file = (File)v;
                String field = String.format(str, key, file.getName(), "application/octet-stream");
                _bytes = StreamHelper.concat(field.getBytes(), FileHelper.openAsByte(file));
            } else {
                String field = String.format(divField, BOUNDARY, key, v.toString());
                _bytes = field.getBytes();
            }
            if (bytes == null) {
                bytes = _bytes;
                continue;
            }
            bytes = StreamHelper.concat(bytes, _bytes);
        }
        return StreamHelper.concat(bytes, endData);
    }

    public static String multiPOST(String url, Map<String, Object> data) {
        return NetUtil.post(url, NetUtil.toFromData(data), (HttpURLConnection conn) -> conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY));
    }
}

