/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.net.http;

import com.ajaxjs.net.http.NetUtil;
import com.ajaxjs.util.logger.LogHelper;
import com.ajaxjs.util.map.JsonHelper;
import com.ajaxjs.util.map.MapTool;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tools {
    private static final LogHelper LOGGER = LogHelper.getLog(Tools.class);
    public static String ip;

    public static String getIp() {
        if (ip == null) {
            ip = Tools.getLocalHostLANAddress().getHostAddress();
        }
        return ip;
    }

    public static InetAddress getLocalHostLANAddress() {
        InetAddress candidateAddress = null;
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                candidateAddress = InetAddress.getLocalHost();
            }
        }
        catch (Exception e) {
            LOGGER.warning(e);
        }
        return candidateAddress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalIp() {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress("baidu.com", 80));
            String string = socket.getLocalAddress().getHostAddress();
            return string;
        }
        catch (IOException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalIp2() {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("114.114.114.114"), 10002);
            String string = socket.getLocalAddress().getHostAddress();
            return string;
        }
        catch (IOException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static boolean isDomianRegisterAvailable(String domain) throws IOException {
        String url = "http://panda.www.net.cn/cgi-bin/check.cgi?area_domain=" + domain;
        String xml = NetUtil.simpleGET(url);
        Map<String, String> map = MapTool.xmlToMap(xml);
        if ("200".equals(map.get("returncode"))) {
            if (map.get("original").startsWith("210")) {
                return true;
            }
            if (map.get("original").startsWith("211")) {
                return false;
            }
            if (map.get("original").startsWith("212")) {
                throw new IOException("\u57df\u540d\u53c2\u6570\u4f20\u8f93\u9519\u8bef");
            }
            throw new IOException("\u672a\u77e5\u9519\u8bef\uff01 " + map);
        }
        throw new IOException("\u63a5\u53e3\u8fd4\u56de\u4e0d\u6210\u529f " + map);
    }

    public static Map<String, String> getWhois(String domain) throws IOException {
        String url = "http://api.k780.com/?app=domain.whois&appkey=10003&sign=b59bc3ef6191eb9f747dd4e83c99f2a4&format=xml&domain=" + domain;
        String xml = NetUtil.simpleGET(url);
        Map<String, String> map = MapTool.xmlToMap(xml);
        if ("1".equals(map.get("success"))) {
            return map;
        }
        throw new IOException("\u63a5\u53e3\u8fd4\u56de\u4e0d\u6210\u529f " + map);
    }

    public static Map<String, Object> getIpLocation(String ip) throws IOException {
        String url = "http://ip.taobao.com/service/getIpInfo.php?ip=" + ip;
        String xml = NetUtil.simpleGET(url);
        Map<String, Object> map = JsonHelper.parseMap(xml);
        if (map != null && map.get("code") != null && 0 == (Integer)map.get("code")) {
            Object obj = map.get("data");
            return (Map)obj;
        }
        throw new IOException("\u63a5\u53e3\u8fd4\u56de\u4e0d\u6210\u529f " + map);
    }

    public static String getIpLocation2(String ip) throws IOException {
        String url = "http://ip-api.com/json/" + ip + "?lang=zh-CN";
        String jsonStr = NetUtil.get(url);
        Map<String, Object> map = JsonHelper.parseMap(jsonStr);
        if (jsonStr != null && map != null && map.get("status").toString().equals("success")) {
            return "" + map.get("country") + map.get("regionName") + map.get("city");
        }
        throw new IOException("\u63a5\u53e3\u8fd4\u56de\u4e0d\u6210\u529f " + jsonStr);
    }

    public static boolean innerIP(String ip) {
        Pattern reg = Pattern.compile("^(127\\.0\\.0\\.1)|(localhost)|(10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})|(172\\.((1[6-9])|(2\\d)|(3[01]))\\.\\d{1,3}\\.\\d{1,3})|(192\\.168\\.\\d{1,3}\\.\\d{1,3})$");
        Matcher match = reg.matcher(ip);
        return match.find();
    }
}

