/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.net.mail;

import com.ajaxjs.net.mail.Mail;
import com.ajaxjs.net.mail.MailException;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.Encode;
import com.ajaxjs.util.logger.LogHelper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;

public class Sender
extends Socket {
    private static final LogHelper LOGGER = LogHelper.getLog(Sender.class);
    public static final String LINEFEET = "\r\n";
    private static final int OK_250_CODE = 250;
    private Mail bean;
    private BufferedReader in;
    private DataOutputStream os;

    public Sender(Mail bean) throws UnknownHostException, IOException {
        super(bean.getMailServer(), bean.getPort());
        this.bean = bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMail() throws MailException {
        LOGGER.info("\u53d1\u9001\u90ae\u4ef6:" + this.bean.getSubject());
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.getInputStream()));
             DataOutputStream os = new DataOutputStream(this.getOutputStream());){
            this.in = in;
            this.os = os;
            String result = in.readLine();
            if (!Sender.isOkCode(result, 220)) {
                throw new MailException("\u521d\u59cb\u5316\u8fde\u63a5\uff1a" + result, 220);
            }
            result = this.sendCommand("HELO %s", this.bean.getMailServer());
            if (!Sender.isOkCode(result, 250)) {
                throw new MailException("\u63e1\u624b\u5931\u8d25\uff1a" + result, 250);
            }
            result = this.sendCommand("AUTH LOGIN");
            if (!Sender.isOkCode(result, 334)) {
                throw new MailException("\u9a8c\u8bc1\u53d1\u4fe1\u4eba\u4fe1\u606f\u5931\u8d25\uff1a" + result, 334);
            }
            result = this.sendCommand(Sender.toBase64(this.bean.getAccount()));
            if (!Sender.isOkCode(result, 334)) {
                throw new MailException("\u53d1\u4fe1\u4eba\u540d\u79f0\u53d1\u9001\u5931\u8d25\uff1a" + result, 334);
            }
            result = this.sendCommand(Sender.toBase64(this.bean.getPassword()));
            if (!Sender.isOkCode(result, 235)) {
                throw new MailException("\u8a8d\u8a3c\u4e0d\u6210\u529f" + result, 235);
            }
            result = this.sendCommand("Mail From:<%s>", this.bean.getFrom());
            if (!Sender.isOkCode(result, 250)) {
                throw new MailException("\u53d1\u9001\u6307\u4ee4 From \u4e0d\u6210\u529f" + result, 250);
            }
            result = this.sendCommand("RCPT TO:<%s>", this.bean.getTo());
            if (!Sender.isOkCode(result, 250)) {
                throw new MailException("\u53d1\u9001\u6307\u4ee4 To \u4e0d\u6210\u529f" + result, 250);
            }
            result = this.sendCommand("DATA");
            if (!Sender.isOkCode(result, 354)) {
                throw new MailException("\u8a8d\u8a3c\u4e0d\u6210\u529f" + result, 354);
            }
            result = this.sendCommand(this.data());
            if (!Sender.isOkCode(result, 250)) {
                throw new MailException("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff1a" + result, 250);
            }
            result = this.sendCommand("QUIT");
            if (!Sender.isOkCode(result, 221)) {
                throw new MailException("QUIT \u5931\u8d25\uff1a" + result, 221);
            }
        }
        catch (UnknownHostException e) {
            System.err.println("\u521d\u59cb\u5316 \u5931\u8d25\uff01\u5efa\u7acb\u8fde\u63a5\u5931\u8d25\uff01");
            LOGGER.warning(e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            System.err.println("\u521d\u59cb\u5316 \u5931\u8d25\uff01\u8bfb\u53d6\u6d41\u5931\u8d25\uff01");
            LOGGER.warning(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                LOGGER.warning(e);
            }
        }
        return true;
    }

    private String data() {
        StringBuilder sb = new StringBuilder();
        sb.append("From:<" + this.bean.getFrom() + ">" + LINEFEET);
        sb.append("To:<" + this.bean.getTo() + ">" + LINEFEET);
        sb.append("Subject:=?UTF-8?B?" + Sender.toBase64(this.bean.getSubject()) + "?=" + LINEFEET);
        sb.append("Date:2016/10/27 17:30\r\n");
        sb.append((this.bean.isHTML_body() ? "Content-Type:text/html;charset=\"utf-8\"" : "Content-Type:text/plain;charset=\"utf-8\"") + LINEFEET);
        sb.append("Content-Transfer-Encoding: base64\r\n");
        sb.append(LINEFEET);
        sb.append(Sender.toBase64(this.bean.getContent()));
        sb.append("\r\n.");
        return sb.toString();
    }

    private String sendCommand(String string, String from) {
        return this.sendCommand(String.format(string, from));
    }

    private String sendCommand(String msg) {
        try {
            this.os.writeBytes(msg + LINEFEET);
            this.os.flush();
            return this.in.readLine();
        }
        catch (IOException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static String toBase64(String str) {
        return Encode.base64Encode(str);
    }

    private static boolean isOkCode(String str, int code) {
        int _code = Integer.parseInt(CommonUtil.regMatch("^\\d+", str));
        return _code == code;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean send(Mail mail) {
        try (Sender sender = new Sender(mail);){
            boolean bl = sender.sendMail();
            return bl;
        }
        catch (MailException | IOException e) {
            LOGGER.warning(e);
            return false;
        }
    }
}

