/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.sql;

import com.ajaxjs.sql.orm.DaoContext;
import com.ajaxjs.util.logger.LogHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JdbcConnection {
    private static final LogHelper LOGGER = LogHelper.getLog(JdbcConnection.class);
    private static ThreadLocal<Connection> connection = new ThreadLocal();
    private static ThreadLocal<List<String>> sqls = new ThreadLocal();
    private static ThreadLocal<DaoContext> ctxThread = new ThreadLocal();

    public static Connection getConnection(String jdbcUrl, Properties props) {
        Connection conn = null;
        try {
            conn = props == null ? DriverManager.getConnection(jdbcUrl) : DriverManager.getConnection(jdbcUrl, props);
            LOGGER.info("\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f\uff1a " + conn.getMetaData().getURL());
        }
        catch (SQLException e) {
            LOGGER.warning("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01", e);
        }
        return conn;
    }

    public static Connection getConnection(String jdbcUrl) {
        return JdbcConnection.getConnection(jdbcUrl, null);
    }

    public static Connection getConnection(DataSource source) {
        try {
            return source.getConnection();
        }
        catch (SQLException e) {
            LOGGER.warning(e, "\u901a\u8fc7\u6570\u636e\u6e90\u5bf9\u8c61\u83b7\u5f97\u6570\u636e\u5e93\u8fde\u63a5\u5bf9\u8c61\u5931\u8d25\uff01");
            return null;
        }
    }

    public static DataSource getDataSourceByJNDI(String jndi) {
        try {
            Object obj = new InitialContext().lookup("java:/comp/env");
            Objects.requireNonNull(obj, "\u6ca1\u6709\u8be5\u8282\u70b9 java:/comp/env");
            Context context = (Context)obj;
            Object result = context.lookup(jndi);
            return (DataSource)result;
        }
        catch (NamingException e) {
            String msg = "\u8bfb\u53d6\u6570\u636e\u6e90\u7684\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5 Tomcat \u8fde\u63a5\u6c60\u914d\u7f6e\uff01 path: " + jndi;
            msg = msg + " \u63d0\u793a\uff1a\u6ca1\u53d1\u73b0\u6570\u636e\u5e93 /WebRoot/META-INF/context.xml \u4e0b\u7684 XML \u914d\u7f6e\u6587\u4ef6\uff0c\u8be5\u6587\u4ef6\u4f4d\u7f6e\u4e00\u822c\u4e0d\u53ef\u79fb\u52a8\uff0c\u8bf7\u53c2\u9605 TomatPool \u6570\u636e\u5e93\u8fde\u63a5\u6c60\u7684\u76f8\u5173\u6587\u6863\u3002";
            LOGGER.warning(msg, e);
            return null;
        }
    }

    public static Connection getConnectionByJNDI(String jndi) {
        return JdbcConnection.getConnection(JdbcConnection.getDataSourceByJNDI(jndi));
    }

    public static void initDbByJNDI(String jndi) {
        Objects.requireNonNull(jndi, "\u7f3a\u5c11 jndiPath \u53c2\u6570\uff01");
        LOGGER.info("\u542f\u52a8[{0}]\u6570\u636e\u5e93 JNDI \u8fde\u63a5", jndi);
        try {
            if (JdbcConnection.getConnection() == null || JdbcConnection.getConnection().isClosed()) {
                Connection conn = JdbcConnection.getConnectionByJNDI(jndi);
                JdbcConnection.getDaoContext().setConnection(conn);
                JdbcConnection.setConnection(conn);
                LOGGER.info("\u6210\u529f\u8fde\u63a5\u6570\u636e\u5e93[{0}]", conn);
            }
        }
        catch (SQLException e) {
            LOGGER.warning(e);
        }
    }

    public static void setDaoContext(DaoContext ctx) {
        ctxThread.set(ctx);
    }

    public static DaoContext getDaoContext() {
        DaoContext cxt = ctxThread.get();
        if (cxt == null) {
            cxt = new DaoContext();
            JdbcConnection.setDaoContext(cxt);
        }
        return cxt;
    }

    public static Connection getConnection() {
        return connection.get();
    }

    public static List<String> getSqls() {
        return sqls.get();
    }

    public static void setConnection(Connection conn) {
        connection.set(conn);
    }

    public static void setSqls(List<String> _sqls) {
        sqls.set(_sqls);
    }

    public static void addSql(String sql) {
        if (JdbcConnection.getSqls() == null) {
            JdbcConnection.setSqls(new ArrayList<String>());
        }
        JdbcConnection.getSqls().add(sql);
    }

    public static void closeDb() {
        Connection conn = JdbcConnection.getConnection();
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
                LOGGER.info("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f\uff01 Close database OK\uff01");
            }
        }
        catch (SQLException e) {
            LOGGER.warning(e);
        }
        JdbcConnection.clean();
    }

    private static void clean() {
        connection.set(null);
        if (JdbcConnection.getSqls() != null) {
            JdbcConnection.getSqls().clear();
            sqls.set(null);
        }
    }

    public static Connection getMySqlConnection(String jdbcUrl, String username, String password) {
        if (!jdbcUrl.startsWith("jdbc:mysql://")) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e3a\u975e\u6cd5\u7684 JDBC URL\uff1a " + jdbcUrl);
        }
        if (!jdbcUrl.contains("?")) {
            jdbcUrl = jdbcUrl + "?";
        }
        return JdbcConnection.getConnection(jdbcUrl + "&user=" + username + "&password=" + password);
    }

    public static Connection getSqliteConnection(String jdbcUrl) {
        if (!jdbcUrl.startsWith("jdbc:sqlite:")) {
            jdbcUrl = "jdbc:sqlite:" + jdbcUrl;
        }
        return JdbcConnection.getConnection(jdbcUrl);
    }
}

