/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.sql;

import com.ajaxjs.sql.JdbcConnection;
import com.ajaxjs.sql.JdbcReader;
import com.ajaxjs.sql.JdbcUtil;
import com.ajaxjs.sql.annotation.IgnoreDB;
import com.ajaxjs.util.MappingValue;
import com.ajaxjs.util.ReflectUtil;
import com.ajaxjs.util.logger.LogHelper;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class JdbcHelper
extends JdbcReader {
    private static final LogHelper LOGGER = LogHelper.getLog(JdbcHelper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T initAndExe(BiFunction<Connection, String, PreparedStatement> initPs, Function<PreparedStatement, T> exe, Connection conn, String sql, Object ... params) {
        String _sql = JdbcUtil.printRealSql(sql, params);
        LOGGER.infoYellow("SQL-->" + _sql);
        JdbcConnection.addSql(_sql);
        try (PreparedStatement ps = initPs.apply(conn, sql);){
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            PreparedStatement t = exe.apply(ps);
            return (T)t;
        }
        catch (SQLException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static Serializable create(Connection conn, String sql, Object ... params) {
        SQLException[] sqlE = new SQLException[1];
        Object newlyId = JdbcHelper.initAndExe((_conn, _sql) -> {
            try {
                return conn.prepareStatement(sql, 1);
            }
            catch (SQLException e) {
                LOGGER.warning(e);
                return null;
            }
        }, ps -> {
            try {
                ps.executeUpdate();
                try (ResultSet rs = ps.getGeneratedKeys();){
                    if (!rs.next()) return null;
                    Object object = rs.getObject(1);
                    return object;
                }
            }
            catch (SQLException e) {
                sqlE[0] = e;
                LOGGER.warning(e);
            }
            return null;
        }, conn, sql, params);
        if (sqlE.length == 1 && sqlE[0] != null) {
            throw new RuntimeException(sqlE[0] + "");
        }
        if (newlyId != null && !(newlyId instanceof Serializable)) {
            LOGGER.warning(String.format("\u8fd4\u56de id :{0} \u7c7b\u578b:{1}", newlyId, newlyId.getClass().getName()));
            throw new RuntimeException("\u8fd4\u56de id \u7c7b\u578b\u4e0d\u662f Serializable");
        }
        return newlyId == null ? Integer.valueOf(0) : (Serializable)newlyId;
    }

    public static int update(Connection conn, String sql, Object ... params) {
        return JdbcHelper.initAndExe((_conn, _sql) -> {
            try {
                return conn.prepareStatement(sql);
            }
            catch (SQLException e) {
                LOGGER.warning(e);
                return null;
            }
        }, ps -> {
            try {
                return ps.executeUpdate();
            }
            catch (SQLException e) {
                LOGGER.warning(e);
                return null;
            }
        }, conn, sql, params);
    }

    private static StringBuilder initSB(String tableName, boolean isInsert) {
        StringBuilder sb = new StringBuilder();
        sb.append(isInsert ? "INSERT INTO " : "UPDATE ");
        sb.append("`" + tableName + "` ");
        if (!isInsert) {
            sb.append("SET");
        }
        sb.append(" ");
        return sb;
    }

    private static void everyMap(Map<String, Object> map, BiConsumer<String, Object> onField) {
        if (map.size() == 0) {
            throw new NullPointerException("\u8be5\u5b9e\u4f53\u6ca1\u6709\u4efb\u4f55\u5b57\u6bb5\u548c\u6570\u636e");
        }
        for (String field : map.keySet()) {
            if ("id".equals(field)) continue;
            onField.accept("`" + field + "`", map.get(field));
        }
    }

    public static Serializable createMap(Connection conn, Map<String, Object> map, String tableName) {
        LOGGER.info("DAO \u521b\u5efa\u8bb0\u5f55 name:{0}\uff01", map.get("name"));
        ArrayList fields = new ArrayList();
        ArrayList placeholders = new ArrayList();
        ArrayList values = new ArrayList();
        JdbcHelper.everyMap(map, (field, value) -> {
            fields.add(field);
            placeholders.add("?");
            values.add(value);
        });
        StringBuilder sb = JdbcHelper.initSB(tableName, true);
        sb.append("(" + String.join((CharSequence)", ", fields) + ")");
        sb.append(" VALUES (" + String.join((CharSequence)", ", placeholders) + ")");
        Serializable newlyId = JdbcHelper.create(conn, sb.toString(), values.toArray());
        map.put("id", newlyId);
        return newlyId;
    }

    public static int updateMap(Connection conn, Map<String, Object> map, String tableName) {
        LOGGER.info("\u66f4\u65b0\u8bb0\u5f55 id:{0}, name:{1}\uff01", map.get("id"), map.get("name"));
        ArrayList fields = new ArrayList();
        ArrayList<Object> values = new ArrayList<Object>();
        JdbcHelper.everyMap(map, (field, value) -> {
            fields.add(field + " = ?");
            values.add(value);
        });
        StringBuilder sb = JdbcHelper.initSB(tableName, false);
        sb.append(String.join((CharSequence)", ", fields));
        sb.append(" WHERE id = ?");
        values.add(map.get("id"));
        return JdbcHelper.update(conn, sb.toString(), values.toArray());
    }

    public static Map<String, BeanMethod> getBeanInfo(Object bean) {
        HashMap<String, BeanMethod> map = new HashMap<String, BeanMethod>();
        Class<?> beanClz = bean.getClass();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClz);
            for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
                String filedName = property.getName();
                if ("class".equals(filedName)) continue;
                Method method = property.getReadMethod();
                BeanMethod m = new BeanMethod();
                m.setFieldName(filedName);
                m.setGetter(method);
                m.setSetter(property.getWriteMethod());
                m.setType(property.getPropertyType());
                m.setIgnoreDB(method.getAnnotation(IgnoreDB.class) == null);
                map.put(filedName, m);
            }
        }
        catch (IntrospectionException e) {
            LOGGER.warning(e);
        }
        return map;
    }

    private static void everyBean(Object bean, BiConsumer<String, Object> onField) {
        Map<String, BeanMethod> infoMap = JdbcHelper.getBeanInfo(bean);
        for (String fieldName : infoMap.keySet()) {
            BeanMethod info = infoMap.get(fieldName);
            Object value = JdbcHelper.valueHander(bean, info);
            if (!info.getIgnoreDB().booleanValue() || value == null || "id".equals(fieldName)) continue;
            onField.accept(fieldName, value);
        }
    }

    private static Object valueHander(Object bean, BeanMethod info) {
        Object value = ReflectUtil.executeMethod(bean, info.getGetter(), new Object[0]);
        Class<?> t = info.getType();
        if (value != null && t != value.getClass()) {
            return MappingValue.objectCast(value, t);
        }
        return value;
    }

    public static Serializable createBean(Connection conn, Object bean, String tableName) {
        ArrayList fields = new ArrayList();
        ArrayList placeholders = new ArrayList();
        ArrayList values = new ArrayList();
        JdbcHelper.everyBean(bean, (field, value) -> {
            fields.add(field);
            placeholders.add("?");
            values.add(value);
        });
        StringBuilder sb = JdbcHelper.initSB(tableName, true);
        sb.append("(" + String.join((CharSequence)", ", fields) + ")");
        sb.append(" VALUES (" + String.join((CharSequence)", ", placeholders) + ")");
        Serializable newlyId = JdbcHelper.create(conn, sb.toString(), values.toArray());
        try {
            Class<?> idClz = bean.getClass().getMethod("getId", new Class[0]).getReturnType();
            if (Long.class == idClz && newlyId instanceof Integer) {
                ReflectUtil.executeMethod(bean, "setId", new Long(((Integer)newlyId).intValue()));
            } else {
                ReflectUtil.executeMethod(bean, "setId", newlyId);
            }
        }
        catch (Throwable e) {
            LOGGER.warning(e);
        }
        return newlyId;
    }

    public static int updateBean(Connection conn, Object bean, String tableName) {
        try {
            LOGGER.info("\u66f4\u65b0\u8bb0\u5f55 id:{0}, name:{1}\uff01", ReflectUtil.executeMethod(bean, "getId", new Object[0]), ReflectUtil.executeMethod(bean, "getName", new Object[0]));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ArrayList fields = new ArrayList();
        ArrayList<Object> values = new ArrayList<Object>();
        JdbcHelper.everyBean(bean, (field, value) -> {
            fields.add(field + " = ?");
            values.add(value);
        });
        StringBuilder sb = JdbcHelper.initSB(tableName, false);
        sb.append(String.join((CharSequence)", ", fields));
        sb.append(" WHERE id = ?");
        values.add(ReflectUtil.executeMethod(bean, "getId", new Object[0]));
        return JdbcHelper.update(conn, sb.toString(), values.toArray());
    }

    public static boolean delete(Connection conn, Object bean, String tableName) {
        if (bean instanceof Map) {
            Map map = (Map)bean;
            return JdbcHelper.deleteById(conn, tableName, (Serializable)map.get("id"));
        }
        return JdbcHelper.deleteById(conn, tableName, (Serializable)ReflectUtil.executeMethod(bean, "getId", new Object[0]));
    }

    public static boolean deleteById(Connection conn, String tableName, Serializable id) {
        return JdbcHelper.update(conn, "DELETE FROM " + tableName + " WHERE id = ?", id) == 1;
    }

    public static class BeanMethod {
        private String fieldName;
        private Method getter;
        private Method setter;
        private Class<?> type;
        private Boolean ignoreDB;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public Method getGetter() {
            return this.getter;
        }

        public void setGetter(Method getter) {
            this.getter = getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        public void setSetter(Method setter) {
            this.setter = setter;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public Boolean getIgnoreDB() {
            return this.ignoreDB;
        }

        public void setIgnoreDB(Boolean ignoreDB) {
            this.ignoreDB = ignoreDB;
        }
    }
}

