/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.sql;

import com.ajaxjs.sql.JdbcConnection;
import com.ajaxjs.sql.Lambda;
import com.ajaxjs.sql.orm.DataBaseType;
import com.ajaxjs.util.MappingValue;
import com.ajaxjs.util.ReflectUtil;
import com.ajaxjs.util.logger.LogHelper;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class JdbcReader {
    private static final LogHelper LOGGER = LogHelper.getLog(JdbcReader.class);

    public static void stmt(Connection conn, Consumer<Statement> handle) {
        try (Statement stmt = conn.createStatement();){
            handle.accept(stmt);
        }
        catch (SQLException e) {
            LOGGER.warning(e);
        }
    }

    public static void rsHandle(Statement stmt, String sql, Consumer<ResultSet> handle) {
        try (ResultSet rs = stmt.executeQuery(sql);){
            handle.accept(rs);
        }
        catch (SQLException e) {
            LOGGER.warning(e);
        }
    }

    public static void query(Connection conn, String sql, Consumer<ResultSet> handle) {
        JdbcReader.stmt(conn, stmt -> JdbcReader.rsHandle(stmt, sql, handle));
    }

    /*
     * Exception decompiling
     */
    public static <T> T select(Connection conn, String sql, Lambda.HasZeroResult hasZeoResult, Lambda.ResultSetProcessor<T> processor, Object ... params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, Object> queryAsMap(Connection conn, String sql, Object ... params) {
        return JdbcReader.select(conn, sql, JdbcReader::hasZeoResult, JdbcReader::getResultMap, params);
    }

    public static <T> T queryAsBean(Class<T> beanClz, Connection connection, String sql, Object ... params) {
        return JdbcReader.select(connection, sql, JdbcReader::hasZeoResult, JdbcReader.getResultBean(beanClz), params);
    }

    public static Map<String, Object> getResultMap(ResultSet rs) throws SQLException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String key = rsmd.getColumnLabel(i);
            Object value = rs.getObject(i);
            map.put(key, value);
        }
        return map;
    }

    public static <T> Lambda.ResultSetProcessor<T> getResultBean(Class<T> beanClz) {
        return rs -> {
            Object bean = ReflectUtil.newInstance(beanClz, new Object[0]);
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String key = rsmd.getColumnLabel(i);
                Object _value = rs.getObject(i);
                try {
                    PropertyDescriptor property = new PropertyDescriptor(key, beanClz);
                    Method method = property.getWriteMethod();
                    Object value = null;
                    try {
                        value = MappingValue.objectCast(_value, property.getPropertyType());
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warning(e, "\u4fdd\u5b58\u6570\u636e\u5230 bean \u7684 {0} \u5b57\u6bb5\u65f6\uff0c\u8f6c\u6362\u5931\u8d25\uff0c\u8f93\u5165\u503c\uff1a{1}\uff0c\u8f93\u5165\u7c7b\u578b \uff1a{2}\uff0c \u671f\u5f85\u7c7b\u578b\uff1a{3}", key, value, value == null ? " \u7a7a\u503c " : value.getClass(), property.getPropertyType());
                        continue;
                    }
                    ReflectUtil.executeMethod(bean, method, value);
                    continue;
                }
                catch (IntrospectionException | IllegalArgumentException e) {
                    if (e instanceof IntrospectionException) {
                        try {
                            if (_value == null || beanClz.getField("extractData") == null) continue;
                            Object obj = ReflectUtil.executeMethod(bean, "getExtractData", new Object[0]);
                            if (obj == null) {
                                HashMap extractData = new HashMap();
                                ReflectUtil.executeMethod(bean, "setExtractData", extractData);
                                obj = ReflectUtil.executeMethod(bean, "getExtractData", new Object[0]);
                            }
                            Map map = (Map)obj;
                            map.put(key, _value);
                        }
                        catch (NoSuchFieldException | SecurityException exception) {}
                        continue;
                    }
                    LOGGER.warning(e);
                }
            }
            return bean;
        };
    }

    public static <T> List<T> queryAsList(Connection conn, String sql, Object ... params) {
        return JdbcReader.select(conn, sql, null, rs -> JdbcReader.forEachRs(rs, _rs -> rs.getObject(0)), params);
    }

    public static List<Map<String, Object>> queryAsMapList(Connection conn, String sql, Object ... params) {
        return JdbcReader.select(conn, sql, null, rs -> JdbcReader.forEachRs(rs, JdbcReader::getResultMap), params);
    }

    public static <T> List<T> queryAsBeanList(Class<T> beanClz, Connection conn, String sql, Object ... params) {
        return JdbcReader.select(conn, sql, null, rs -> JdbcReader.forEachRs(rs, JdbcReader.getResultBean(beanClz)), params);
    }

    static <T> List<T> forEachRs(ResultSet rs, Lambda.ResultSetProcessor<T> processor) throws SQLException {
        ArrayList<T> list = new ArrayList<T>();
        while (rs.next()) {
            T d = processor.process(rs);
            list.add(d);
        }
        return list.size() > 0 ? list : null;
    }

    static boolean hasZeoResult(Connection conn, ResultSet rs, String sql) throws SQLException {
        boolean hasNext = JdbcConnection.getDaoContext().getDbType() == DataBaseType.SQLITE ? rs.isBeforeFirst() : rs.next();
        if (hasNext) {
            return true;
        }
        LOGGER.info("\u67e5\u8be2 SQL\uff1a{0} \u6ca1\u6709\u7b26\u5408\u7684\u8bb0\u5f55\uff01", sql);
        return false;
    }

    public static <T> T queryOne(Connection conn, String sql, Class<T> clz, Object ... params) {
        Iterator<String> iterator;
        Map<String, Object> map = JdbcReader.queryAsMap(conn, sql, params);
        if (map != null && (iterator = map.keySet().iterator()).hasNext()) {
            String key = iterator.next();
            Object obj = map.get(key);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Long && clz == Integer.TYPE) {
                Integer _int = ((Long)obj).intValue();
                return (T)_int;
            }
            if (obj instanceof Integer && (clz == Long.TYPE || clz == Long.class)) {
                Long _int = ((Integer)obj).longValue();
                return (T)_int;
            }
            return (T)obj;
        }
        return null;
    }

    public static <T> T[] queryArray(Connection conn, String sql, Class<T> clz, Object ... params) {
        return JdbcReader.select(conn, sql, null, rs -> {
            List<Object> list = JdbcReader.forEachRs(rs, _rs -> rs.getObject(1));
            if (list == null) {
                return null;
            }
            Object array = Array.newInstance(clz, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
            return (Object[])array;
        }, params);
    }
}

