/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.sql;

import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.logger.LogHelper;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JdbcUtil {
    private static final LogHelper LOGGER = LogHelper.getLog(JdbcUtil.class);
    public static boolean IS_DB_CONNECTION_AUTOCLOSE = true;
    public static boolean isClosePrintRealSql = false;

    public static String printRealSql(String sql, Object[] params) {
        if (CommonUtil.isEmptyString(sql)) {
            throw new IllegalArgumentException("SQL \u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (isClosePrintRealSql) {
            return null;
        }
        if (params == null || params.length == 0) {
            return sql;
        }
        if (!JdbcUtil.match(sql, params)) {
            LOGGER.info("SQL \u8bed\u53e5\u4e2d\u7684\u5360\u4f4d\u7b26\u4e0e\u503c\u53c2\u6570\uff08\u4e2a\u6570\u4e0a\uff09\u4e0d\u5339\u914d\u3002SQL\uff1a{0}\uff0c\nparams:{1}", sql, Arrays.toString(params));
        }
        if (sql.endsWith("?")) {
            sql = sql + " ";
        }
        CharSequence[] arr = sql.split("\\?");
        for (int i = 0; i < arr.length - 1; ++i) {
            Object value = params[i];
            String inSql = value instanceof Date ? "'" + value + "'" : (value instanceof String ? "'" + value + "'" : (value instanceof Boolean ? ((Boolean)value != false ? "1" : "0") : value.toString()));
            arr[i] = (String)arr[i] + inSql;
        }
        return String.join((CharSequence)" ", arr).trim();
    }

    private static boolean match(String sql, Object[] params) {
        if (params == null || params.length == 0) {
            return true;
        }
        Matcher m = Pattern.compile("(\\?)").matcher(sql);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        return count == params.length;
    }

    public static String formatSql(String sql) {
        String separator = System.getProperty("line.separator");
        sql = '\t' + sql;
        sql = sql.replaceAll("(?i)SELECT\\s+", "SELECT ");
        sql = sql.replaceAll("\\s+(?i)FROM", separator + "\tFROM");
        sql = sql.replaceAll("\\s+(?i)WHERE", separator + "\tWHERE");
        sql = sql.replaceAll("\\s+(?i)GROUP BY", separator + "\tGROUP BY");
        sql = sql.replaceAll("\\s+(?i)ORDER BY", separator + "\tORDER BY");
        sql = sql.replaceAll("\\s+(?i)LIMIT", separator + "\tLIMIT");
        sql = sql.replaceAll("\\s+(?i)DESC", " DESC");
        sql = sql.replaceAll("\\s+(?i)ASC", " ASC");
        return sql;
    }
}

