/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.sql;

public class SnowflakeId {
    private final long epoch = 1514736000000L;
    private final long workerIdBits = 4L;
    private final long sequenceBits = 12L;
    private final long maxWorkerId;
    private final long workerIdShift;
    private final long timestampLeftShift;
    private final long sequenceMask;
    private final long workerId;
    private long sequence;
    private long lastTimestamp;

    public SnowflakeId(long workerId) {
        this.getClass();
        this.maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << 4;
        this.workerIdShift = this.sequenceBits;
        this.timestampLeftShift = this.sequenceBits + this.workerIdBits;
        this.getClass();
        this.sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << 12;
        this.sequence = 0L;
        this.lastTimestamp = -1L;
        if (workerId > this.maxWorkerId || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", this.maxWorkerId));
        }
        this.workerId = workerId;
    }

    public synchronized long nextId() {
        long timestamp = System.currentTimeMillis();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("clock moved backwards.Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.epoch << (int)this.timestampLeftShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    public static long get() {
        return new SnowflakeId(1L).nextId();
    }
}

