/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.sql.orm;

import com.ajaxjs.sql.annotation.SqlFactory;
import com.ajaxjs.sql.orm.DaoException;
import com.ajaxjs.sql.orm.model.ArgsInfo;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.ReflectUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.function.Function;

public class DaoSqlHandler {
    static ArgsInfo doSql(String sql, Method method, Object[] args) {
        ArgsInfo info = new ArgsInfo();
        info.sql = sql;
        info.args = args;
        info.method = method;
        Object[] parameters = method.getParameters();
        if (!CommonUtil.isNull(args) && !CommonUtil.isNull(parameters)) {
            String realSql = null;
            ArrayList<Object> list = new ArrayList<Object>();
            boolean found = false;
            for (int i = 0; i < args.length; ++i) {
                Object obj = args[i];
                Object p = parameters[i];
                if (Function.class.equals(((Parameter)p).getType())) {
                    found = true;
                    if (obj instanceof Function) {
                        Function fn = (Function)obj;
                        String _sql = (String)fn.apply(sql);
                        if (_sql == null) {
                            info.isStop = true;
                        }
                        realSql = _sql == null ? sql : _sql;
                        info.sqlHandler = fn;
                        continue;
                    }
                    realSql = sql;
                    info.sqlHandler = null;
                    continue;
                }
                list.add(obj);
            }
            if (found) {
                info.sql = realSql;
                info.args = list.toArray();
            }
        }
        return info;
    }

    static String doSqlFactory(String sql, Method method, Class<?> daoClz) throws DaoException {
        Method sqlFactoryHandler;
        SqlFactory sqlFactory = method.getAnnotation(SqlFactory.class);
        String methodName = sqlFactory.value();
        Class<?> clz = sqlFactory.clz();
        if (clz == null || clz.equals(Object.class)) {
            clz = daoClz;
        }
        if ((sqlFactoryHandler = ReflectUtil.getMethod(clz, methodName, String.class)) == null) {
            throw new DaoException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684 SqlFactory\uff0c\u5e94\u8be5\u4e3a Function<String, String>");
        }
        sql = ReflectUtil.executeStaticMethod(sqlFactoryHandler, sql).toString();
        return sql;
    }
}

