/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.sql.orm;

import com.ajaxjs.framework.BaseModel;
import com.ajaxjs.sql.JdbcConnection;
import com.ajaxjs.sql.annotation.Delete;
import com.ajaxjs.sql.annotation.Insert;
import com.ajaxjs.sql.annotation.Update;
import com.ajaxjs.sql.orm.DaoException;
import com.ajaxjs.sql.orm.DataBaseType;
import com.ajaxjs.sql.orm.RepositoryReadOnly;
import com.ajaxjs.sql.orm.model.DaoInfo;
import com.ajaxjs.util.CommonUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class Repository
extends RepositoryReadOnly {
    private Function<DaoInfo, Serializable> createEntity = daoInfo -> daoInfo.isMap ? Repository.createMap(this.conn, (Map)daoInfo.bean, daoInfo.tableName) : Repository.createBean(this.conn, daoInfo.bean, daoInfo.tableName);
    private Function<DaoInfo, Integer> updateEntity = daoInfo -> daoInfo.isMap ? Repository.updateMap(this.conn, (Map)daoInfo.bean, daoInfo.tableName) : Repository.updateBean(this.conn, daoInfo.bean, daoInfo.tableName);

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws DaoException {
        if (this.init(method)) {
            return "This is a AJAXJS DAO.";
        }
        if (Repository.isRead(method)) {
            return this.select(method, args);
        }
        if (Repository.isCreate(method)) {
            return this.insert(method, args);
        }
        if (Repository.isUpdate(method)) {
            return this.update(method, args);
        }
        if (Repository.isDelete(method)) {
            return this.delete(method, args);
        }
        if (method.toString().contains("saveOrUpdate")) {
            Supplier fn = (Supplier)args[1];
            Serializable id = (Serializable)fn.get();
            if (id != null) {
                if (args[0] instanceof Map) {
                    ((Map)args[0]).put("id", Long.parseLong(id + ""));
                } else {
                    ((BaseModel)args[0]).setId(Long.parseLong(id + ""));
                }
                return this.update(method, new Object[]{args[0]});
            }
            return this.insert(method, new Object[]{args[0]});
        }
        throw new DaoException("\u6ca1\u6709\u4efb\u4f55 DAO CRUD \u7684\u6ce8\u89e3\u3002\u4f60\u7ee7\u627f IDAO \u63a5\u53e3\u7684\u5b50\u63a5\u53e3\u4e2d\uff0c\u53ef\u80fd\u6ca1\u6709\u8986\u76d6 IDAO \u7684\u65b9\u6cd5" + method);
    }

    private <T> T getFn(Supplier<String> getSql, Supplier<String> getTableName, Object[] args, Method method, Function<DaoInfo, T> writeSql, Function<DaoInfo, T> writeBean) throws DaoException {
        Object bean = args[0];
        DaoInfo daoInfo = new DaoInfo();
        daoInfo.sql = getSql == null ? "" : getSql.get();
        daoInfo.tableName = getTableName == null || CommonUtil.isEmptyString(getTableName.get()) ? this.getTableName() : getTableName.get();
        daoInfo.isMap = bean instanceof Map;
        daoInfo.bean = bean;
        if (!CommonUtil.isEmptyString(daoInfo.sql)) {
            daoInfo.sql = this.handleSql((String)daoInfo.sql, (Method)method, (Object[])args).sql;
            return writeSql.apply(daoInfo);
        }
        if (CommonUtil.isEmptyString(daoInfo.sql) && bean != null) {
            return writeBean.apply(daoInfo);
        }
        throw new DaoException("\u7a0b\u5e8f\u9519\u8bef");
    }

    private <R> Serializable insert(Method method, Object[] args) throws DaoException {
        Serializable id;
        Class<?> returnType = this.getReturnType(method);
        Insert insert = method.getAnnotation(Insert.class);
        Function<DaoInfo, Serializable> writeSql = daoInfo -> Repository.create(this.conn, daoInfo.sql, args);
        Serializable serializable = id = insert == null ? this.getFn(null, null, args, method, writeSql, this.createEntity) : this.getFn(insert::value, insert::tableName, args, method, writeSql, this.createEntity);
        if (id == null) {
            return null;
        }
        if ((returnType == Integer.class || returnType == Integer.TYPE) && id.getClass() == Long.class) {
            return Integer.valueOf(Integer.parseInt("" + id));
        }
        if ((returnType == Long.class || returnType == Long.TYPE) && id.getClass() == Integer.class) {
            return new Long(((Integer)id).intValue());
        }
        return id;
    }

    private int update(Method method, Object[] args) throws DaoException {
        Update update = method.getAnnotation(Update.class);
        Function<DaoInfo, Integer> writeSql = daoInfo -> Repository.update(this.conn, daoInfo.sql, args);
        return update == null ? this.getFn(null, null, args, method, writeSql, this.updateEntity).intValue() : this.getFn(update::value, update::tableName, args, method, writeSql, this.updateEntity).intValue();
    }

    private Boolean delete(Method method, Object[] args) throws DaoException {
        Delete delete = method.getAnnotation(Delete.class);
        Supplier<String> getSql = JdbcConnection.getDaoContext().getDbType() == DataBaseType.SQLITE ? delete::sqliteValue : delete::value;
        return this.getFn(getSql, delete::tableName, args, method, daoInfo -> Repository.update(this.conn, daoInfo.sql, args) >= 1, daoInfo -> Repository.delete(this.conn, daoInfo.bean, daoInfo.tableName));
    }
}

