/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.sql.orm;

import com.ajaxjs.sql.JdbcConnection;
import com.ajaxjs.sql.JdbcHelper;
import com.ajaxjs.sql.annotation.Delete;
import com.ajaxjs.sql.annotation.Insert;
import com.ajaxjs.sql.annotation.Select;
import com.ajaxjs.sql.annotation.TableName;
import com.ajaxjs.sql.annotation.Update;
import com.ajaxjs.sql.orm.DaoException;
import com.ajaxjs.sql.orm.IBaseDao;
import com.ajaxjs.util.CommonUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class RepositoryBase
extends JdbcHelper
implements InvocationHandler {
    Connection conn;
    private Class<? extends IBaseDao<?>> clz;
    private Class<?> beanClz;
    private String tableName;
    private static BiFunction<Method, Class<? extends Annotation>, Boolean> isNull = (method, a) -> method.getAnnotation(a) != null;
    private static Function<Class<? extends Annotation>, Function<Method, Boolean>> higherOrderFn = a -> method -> isNull.apply((Method)method, (Class<? extends Annotation>)a);
    static Function<Method, Boolean> isRead = higherOrderFn.apply(Select.class);
    static Function<Method, Boolean> isCreate = higherOrderFn.apply(Insert.class);
    static Function<Method, Boolean> isUpdate = higherOrderFn.apply(Update.class);
    static Function<Method, Boolean> isDelete = higherOrderFn.apply(Delete.class);

    public Class<? extends IBaseDao<?>> getClz() {
        return this.clz;
    }

    public void setClz(Class<? extends IBaseDao<?>> clz) {
        this.clz = clz;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Class<?> getBeanClz() {
        return this.beanClz;
    }

    public void setBeanClz(Class<?> beanClz) {
        this.beanClz = beanClz;
    }

    boolean init(Method method) throws DaoException {
        this.conn = JdbcConnection.getConnection();
        if (this.conn == null) {
            throw new DaoException("\u6ca1\u6709 connection\uff0c \u8bf7\u5148\u5efa\u7acb\u6570\u636e\u5e93\u8fde\u63a5\u5bf9\u8c61\u3002");
        }
        return method.getName().equals("toString");
    }

    public <T extends IBaseDao<?>> T bind(Class<T> clz) {
        this.setClz(clz);
        TableName tableNameA = clz.getAnnotation(TableName.class);
        if (tableNameA != null && !CommonUtil.isEmptyString(tableNameA.value())) {
            this.setTableName(tableNameA.value());
        }
        Object obj = Proxy.newProxyInstance(clz.getClassLoader(), new Class[]{clz}, (InvocationHandler)this);
        return (T)((IBaseDao)obj);
    }

    public <T extends IBaseDao<?>> T bind(Class<T> clz, String tableName) {
        this.setTableName(tableName);
        return this.bind(clz);
    }

    public <T extends IBaseDao<?>> T bind(Class<T> clz, String tableName, Class<?> beanClz) {
        this.setTableName(tableName);
        this.setBeanClz(beanClz);
        return this.bind(clz);
    }

    static boolean isRead(Method method) {
        return isNull.apply(method, Select.class);
    }

    static boolean isCreate(Method method) {
        return isNull.apply(method, Insert.class);
    }

    static boolean isUpdate(Method method) {
        return isNull.apply(method, Update.class);
    }

    static boolean isDelete(Method method) {
        return isNull.apply(method, Delete.class);
    }
}

