/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.sql.orm;

import com.ajaxjs.sql.JdbcConnection;
import com.ajaxjs.sql.annotation.Select;
import com.ajaxjs.sql.annotation.SqlFactory;
import com.ajaxjs.sql.annotation.TableName;
import com.ajaxjs.sql.orm.DaoException;
import com.ajaxjs.sql.orm.DaoSqlHandler;
import com.ajaxjs.sql.orm.DataBaseType;
import com.ajaxjs.sql.orm.PageResult;
import com.ajaxjs.sql.orm.RepositoryBase;
import com.ajaxjs.sql.orm.model.ArgsInfo;
import com.ajaxjs.sql.orm.model.PageParams;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.logger.LogHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class RepositoryReadOnly
extends RepositoryBase {
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws DaoException {
        if (this.init(method)) {
            return "This is a AJAXJS DAO.";
        }
        return this.select(method, args);
    }

    Class<?> getReturnType(Method method) throws DaoException {
        Class<?> clz = method.getReturnType();
        if (clz == Map.class || clz == List.class || clz == PageResult.class || clz == Integer.TYPE || clz == Integer.class || clz == Long.TYPE || clz == Long.class || clz == String.class || clz == Boolean.class || clz == Boolean.TYPE || clz.isArray()) {
            return clz;
        }
        TableName t = this.getClz().getAnnotation(TableName.class);
        if (t == null && this.getBeanClz() == null) {
            throw new DaoException("\u8bf7\u8bbe\u7f6e\u6ce8\u89e3 TableName \u7684 beanClass \u6216\u9001\u5165 beanClz");
        }
        clz = this.getBeanClz() == null ? t.beanClass() : this.getBeanClz();
        return clz;
    }

    public ArgsInfo handleSql(String sql, Method method, Object[] args) throws DaoException {
        if (method != null && method.getAnnotation(SqlFactory.class) != null) {
            sql = DaoSqlHandler.doSqlFactory(sql, method, this.getClz());
        }
        if (this.getTableName() != null) {
            sql = sql.replaceAll("\\$\\{\\w+\\}", this.getTableName());
        }
        return DaoSqlHandler.doSql(sql, method, args);
    }

    Object select(Method method, Object[] args) throws DaoException {
        Select select = method.getAnnotation(Select.class);
        String sql = JdbcConnection.getDaoContext().getDbType() == DataBaseType.SQLITE && !CommonUtil.isEmptyString(select.sqliteValue()) ? select.sqliteValue() : select.value();
        ArgsInfo info = this.handleSql(sql, method, args);
        if (info.isStop) {
            return null;
        }
        sql = info.sql;
        args = info.args;
        Class<?> returnType = this.getReturnType(method);
        Object result = null;
        if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            result = RepositoryReadOnly.queryOne(this.conn, sql, Object.class, args) == null;
        } else if (returnType == Integer.TYPE || returnType == Integer.class) {
            result = RepositoryReadOnly.queryOne(this.conn, sql, Integer.TYPE, args);
        } else if (returnType == Long.TYPE || returnType == Long.class) {
            result = RepositoryReadOnly.queryOne(this.conn, sql, Long.TYPE, args);
        } else if (returnType == Integer[].class) {
            result = RepositoryReadOnly.queryArray(this.conn, sql, Integer.class, args);
        } else if (returnType == String[].class) {
            result = RepositoryReadOnly.queryArray(this.conn, sql, String.class, args);
        } else if (returnType == String.class) {
            result = RepositoryReadOnly.queryOne(this.conn, sql, String.class, args);
        } else if (returnType == List.class || returnType == PageResult.class) {
            Class<?> entryType = this.getEntryContainerType(method);
            if (returnType == List.class) {
                Object object = result = entryType == Map.class ? RepositoryReadOnly.queryAsMapList(this.conn, sql, args) : RepositoryReadOnly.queryAsBeanList(entryType, this.conn, sql, args);
            }
            if (returnType == PageResult.class) {
                result = this.doPage(entryType, select, info);
            }
        } else {
            result = returnType == Map.class ? RepositoryReadOnly.queryAsMap(this.conn, sql, args) : RepositoryReadOnly.queryAsBean(returnType, this.conn, sql, args);
        }
        return result;
    }

    private Class<?> getEntryContainerType(Method method) throws DaoException {
        ParameterizedType _type;
        Type[] typeArray;
        int n;
        int n2;
        Type returnType;
        Class<?> type = method.getReturnType();
        if (type.isArray()) {
            return type.getComponentType();
        }
        if ((type == List.class || type == PageResult.class) && (returnType = method.getGenericReturnType()) instanceof ParameterizedType && (n2 = 0) < (n = (typeArray = (_type = (ParameterizedType)returnType).getActualTypeArguments()).length)) {
            Type typeArgument = typeArray[n2];
            if ("T".equals(typeArgument.toString())) {
                TableName t = this.getClz().getAnnotation(TableName.class);
                if (t == null && this.getBeanClz() == null) {
                    throw new DaoException("\u8bf7\u8bbe\u7f6e\u6ce8\u89e3 TableName \u7684 beanClass \u6216\u9001\u5165 beanClz");
                }
                return this.getBeanClz() == null ? t.beanClass() : this.getBeanClz();
            }
            if (typeArgument instanceof ParameterizedTypeImpl) {
                return Map.class;
            }
            return (Class)typeArgument;
        }
        return type;
    }

    public <T> PageResult<T> doPage(Class<T> entityType, Select select, ArgsInfo info) throws DaoException {
        PageParams p = RepositoryReadOnly.getPageParameters(info.method, info.args);
        int total = this.countTotal(select, info.sql, p.args, info);
        PageResult result = new PageResult();
        if (total <= 0) {
            LogHelper.p(info.sql + " \u67e5\u8be2\u5b8c\u6bd5\uff0c\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55");
            result.setZero(true);
        } else {
            int start = p.pageParams[0];
            int limit = p.pageParams[1];
            List<Map<String, Object>> list = entityType == Map.class ? RepositoryReadOnly.queryAsMapList(this.conn, info.sql + " LIMIT ?, ?", info.args) : RepositoryReadOnly.queryAsBeanList(entityType, this.conn, info.sql + " LIMIT ?, ?", info.args);
            result.setStart(start);
            result.setPageSize(limit);
            result.setTotalCount(total);
            result.page();
            if (list != null) {
                result.addAll(list);
            }
        }
        return result;
    }

    private int countTotal(Select select, String sql, Object[] args, ArgsInfo info) throws DaoException {
        if (CommonUtil.isEmptyString(sql)) {
            throw new NullPointerException("SQL \u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String countSql = select.countSql();
        String sqliteCountSql = select.sqliteCountSql();
        String _sql = CommonUtil.isEmptyString(countSql) ? "SELECT COUNT(*) AS count FROM (" + sql + ") AS t;" : countSql;
        switch (JdbcConnection.getDaoContext().getDbType()) {
            case MYSQL: {
                _sql = this.handleSql((String)_sql, (Method)info.method, (Object[])args).sql;
                Long total = RepositoryReadOnly.queryOne(this.conn, _sql, Long.class, args);
                return total == null ? 0 : total.intValue();
            }
            case SQLITE: {
                if (!CommonUtil.isEmptyString(sqliteCountSql)) {
                    _sql = sqliteCountSql;
                }
                _sql = this.handleSql((String)_sql, (Method)info.method, (Object[])args).sql;
                return RepositoryReadOnly.queryOne(this.conn, _sql, Integer.class, args);
            }
        }
        throw new UnsupportedOperationException("\u62b1\u6b49\uff01\u4e0d\u652f\u6301\u8fd9\u79cd\u6570\u636e\u5e93");
    }

    private static PageParams getPageParameters(Method method, Object[] args) {
        PageParams p = new PageParams();
        int[] pageParams = new int[2];
        Object[] parameters = method.getParameters();
        if (CommonUtil.isNull(parameters)) {
            pageParams[0] = 0;
            pageParams[1] = 8;
        }
        Integer removeStartIndex = null;
        Integer removeLimitIndex = null;
        Integer sqlHandlerIndex = null;
        for (int i = 0; i < parameters.length; ++i) {
            Object _param = parameters[i];
            String param = ((Parameter)_param).getName();
            if ("arg0".equals(param) || "arg1".equals(param)) {
                throw new Error(" Java 8 \u652f\u6301\u53cd\u5c04\u83b7\u53d6 \u53c2\u6570 \u5177\u4f53\u540d\u79f0\uff0c\u4f46\u8981\u6253\u5f00\u7f16\u8bd1\u5f00\u5173\u3002\u4f8b\u5982 Eclipse \u987b\u5728 Store information about method parameters (usable via reflection) \u6253\u52fe\uff0c\u6216\u8005\u7f16\u8bd1\u65f6\u52a0\u5165\u53c2\u6570 -parameters\u3002");
            }
            if (param.equalsIgnoreCase("start")) {
                pageParams[0] = (Integer)args[i];
                removeStartIndex = i;
                continue;
            }
            if (param.equalsIgnoreCase("limit")) {
                int l = (Integer)args[i];
                if (l == 0) {
                    pageParams[1] = 8;
                    args[i] = 8;
                } else {
                    pageParams[1] = l;
                }
                removeLimitIndex = i;
                continue;
            }
            if (!Function.class.equals(((Parameter)_param).getType())) continue;
            sqlHandlerIndex = i;
        }
        ArrayList<Object> sqlArgs = new ArrayList<Object>();
        Integer i = 0;
        while (i < args.length) {
            if (!(i.equals(removeStartIndex) || i.equals(removeLimitIndex) || i.equals(sqlHandlerIndex))) {
                sqlArgs.add(args[i]);
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        p.pageParams = pageParams;
        p.args = sqlArgs.toArray();
        return p;
    }
}

