/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_SHORT = "yyyy-MM-dd HH:mm";
    public static final String DATE_FORMAT_SHORTER = "yyyy-MM-dd";
    private static final String DATE_YEAR = "((19|20)[0-9]{2})-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01])";
    private static final Pattern DATE_YEAR_PATTERN = Pattern.compile("((19|20)[0-9]{2})-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01])");
    private static final Pattern DATE_PATTERN = Pattern.compile("((19|20)[0-9]{2})-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01]) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]");
    private static final Map<String, SimpleDateFormat> FORMATERS = new ConcurrentHashMap<String, SimpleDateFormat>();
    private static final String STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static boolean isEmptyString(String str) {
        return str == null || str.isEmpty() || str.trim().isEmpty();
    }

    public static String[] split(String str) {
        return str.split(",|/|-|\\\\|\\||;");
    }

    public static String repeatStr(String str, String div, int repeat) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i++ < repeat) {
            s.append(str);
            if (i == repeat) continue;
            s.append(div);
        }
        return s.toString();
    }

    public static boolean containsIgnoreCase(String a, String b) {
        return a.toLowerCase().contains(b.toLowerCase());
    }

    private static Matcher getMatcher(String regexp, String str) {
        return Pattern.compile(regexp).matcher(str);
    }

    public static String regMatch(String regexp, String str) {
        return CommonUtil.regMatch(regexp, str, 0);
    }

    public static String regMatch(String regexp, String str, int groupIndex) {
        Matcher m = CommonUtil.getMatcher(regexp, str);
        return m.find() ? m.group(groupIndex == -1 ? m.groupCount() : groupIndex) : null;
    }

    public static String[] regMatchAll(String regexp, String str) {
        Matcher m = CommonUtil.getMatcher(regexp, str);
        ArrayList<String> list = new ArrayList<String>();
        while (m.find()) {
            String g = m.group();
            list.add(g);
        }
        String[] result = list.toArray(new String[list.size()]);
        return result;
    }

    public static boolean isNull(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean isNull(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNull(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static String formatDate(Date date) {
        return CommonUtil.simpleDateFormatFactory(DATE_FORMAT).format(date);
    }

    public static String formatDateShorter(Date date) {
        return CommonUtil.simpleDateFormatFactory(DATE_FORMAT_SHORT).format(date);
    }

    public static String now(String format) {
        return CommonUtil.simpleDateFormatFactory(format).format(new Date());
    }

    public static String now() {
        return CommonUtil.now(DATE_FORMAT);
    }

    public static Date Objet2Date(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Long) {
            return new Date((Long)obj);
        }
        if (obj instanceof Integer) {
            return CommonUtil.Objet2Date(Long.parseLong(obj + "000"));
        }
        if (obj instanceof String) {
            String str = obj.toString();
            if (CommonUtil.isEmptyString(str)) {
                return null;
            }
            try {
                if (DATE_PATTERN.matcher(str).matches()) {
                    return CommonUtil.simpleDateFormatFactory(DATE_FORMAT).parse(str);
                }
                if (DATE_YEAR_PATTERN.matcher(str).matches()) {
                    return CommonUtil.simpleDateFormatFactory(DATE_FORMAT_SHORTER).parse(str);
                }
                return CommonUtil.simpleDateFormatFactory(DATE_FORMAT_SHORT).parse(str);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static SimpleDateFormat simpleDateFormatFactory(String format) {
        if (!FORMATERS.containsKey(format)) {
            FORMATERS.put(format, new SimpleDateFormat(format));
        }
        return FORMATERS.get(format);
    }

    public static String getRandomString(int length) {
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            sb.append(STR.charAt(number));
        }
        return sb.toString();
    }
}

