/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DateAutoCast {
    public static final String DATE_FORMAT_NO_SPLIT_REGEX = "^(\\d{4})(\\d{2})(\\d{2})$";
    public static final String DATE_FORMAT_COMMON_REGEX = "^(\\d{4,})[/-](\\d{1,2})[/-](\\d{1,2})$";
    public static final String DATE_FORMAT_COMMON_REPLACE = "$1-$2-$3 00:00:00.000";
    public static final String DATE_FORMAT_REVERT_REGEX = "^(\\d{1,2})[/-](\\d{1,2})[/-](\\d{4,})$";
    public static final String DATE_FORMAT_REVERT_REPLACE = "$3-$2-$1 00:00:00.000";
    public static final String DATETIME_HOUR_FORMAT_REGEX = "^(\\d{4,})[/-](\\d{1,2})[/-](\\d{1,2}).{1}(\\d{1,2}):(\\d{1,2})$";
    public static final String DATETIME_HOUR_FORMAT_REPLACE = "$1-$2-$3 $4:$5:00.000";
    public static final String DATETIME_FORMAT_REGEX = "^(\\d{4,})[/-](\\d{1,2})[/-](\\d{1,2}).{1}(\\d{1,2}):(\\d{1,2}):(\\d{1,2})$";
    public static final String DATETIME_FORMAT_REPLACE = "$1-$2-$3 $4:$5:$6.000";
    public static final String DATETIME_FULL_FORMAT = "yyyy-MM-dd HH:MM:SS";
    private static List<DateReplace> autoDateCache = new ArrayList<DateReplace>();

    public static void registerAutoFormat(String regex, String replace) {
        DateAutoCast.registerAutoFormat(regex, replace, true);
    }

    public static void registerAutoFormat(String regex, String replace, boolean end) {
        DateReplace item = new DateReplace();
        item.regex = regex;
        item.replace = replace;
        item.end = end;
        autoDateCache.add(item);
    }

    public static Date getAutoDate(String date) throws ParseException {
        if (date == null) {
            return null;
        }
        int size = autoDateCache.size();
        for (int i = size - 1; i >= 0; --i) {
            DateReplace item = autoDateCache.get(i);
            String dateTo = date.replaceAll(item.regex, item.replace);
            boolean isBreak = item.end && !dateTo.equals(date);
            date = dateTo;
            if (isBreak) break;
        }
        return new SimpleDateFormat(DATETIME_FULL_FORMAT).parse(String.valueOf(date));
    }

    public static void main(String[] args) throws ParseException {
        System.out.println(DateAutoCast.getAutoDate("1987-11-04"));
        System.out.println(DateAutoCast.getAutoDate("1987-11-04 12:50"));
        System.out.println(DateAutoCast.getAutoDate("1987-11-04 12:50:15"));
        System.out.println(DateAutoCast.getAutoDate("1987-11-04 12:50:15.000"));
        System.out.println(DateAutoCast.getAutoDate("19871104"));
        System.out.println(DateAutoCast.getAutoDate("04/11/1987"));
    }

    static {
        DateAutoCast.registerAutoFormat(DATE_FORMAT_NO_SPLIT_REGEX, DATE_FORMAT_COMMON_REPLACE);
        DateAutoCast.registerAutoFormat(DATE_FORMAT_COMMON_REGEX, DATE_FORMAT_COMMON_REPLACE);
        DateAutoCast.registerAutoFormat(DATE_FORMAT_REVERT_REGEX, DATE_FORMAT_REVERT_REPLACE);
        DateAutoCast.registerAutoFormat(DATETIME_HOUR_FORMAT_REGEX, DATETIME_HOUR_FORMAT_REPLACE);
        DateAutoCast.registerAutoFormat(DATETIME_FORMAT_REGEX, DATETIME_FORMAT_REPLACE);
    }

    private static class DateReplace {
        public String regex;
        public String replace;
        public boolean end;

        private DateReplace() {
        }
    }
}

