/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util;

import com.ajaxjs.util.logger.LogHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class Encode {
    private static final LogHelper LOGGER = LogHelper.getLog(Encode.class);
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);

    public static String byte2String(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String byte2String(String str) {
        return Encode.byte2String(str.getBytes());
    }

    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static String urlChinese(String str) {
        return Encode.byte2String(str.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static String base64Encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static String base64Encode(String str) {
        return Encode.base64Encode(str.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] base64DecodeAsByte(String str) {
        try {
            return Base64.getDecoder().decode(str);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning("BASE64 \u89e3\u7801\u5931\u8d25", e);
            return null;
        }
    }

    public static String base64Decode(String str) {
        byte[] b = Encode.base64DecodeAsByte(str);
        return b == null ? null : Encode.byte2String(b);
    }

    public static String md5(String str) {
        return Encode.hash("MD5", str);
    }

    private static String hash(String hash, String str) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(hash);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.warning(e);
            return null;
        }
        md.update(str.getBytes(StandardCharsets.UTF_8));
        return Encode.bytesToHex(md.digest()).toLowerCase();
    }

    public static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    public static String getSHA1(String str) {
        return Encode.hash("SHA1", str);
    }

    public static String getSHA256(String str) {
        return Encode.hash("SHA-256", str);
    }
}

