/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util;

import com.ajaxjs.util.CommonUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;

public class MappingValue {
    private static final char DIVER = ',';

    public static Object toJavaValue(String value) {
        block12: {
            if (value == null) {
                return null;
            }
            if ("".equals(value = value.trim())) {
                return "";
            }
            if ("null".equals(value)) {
                return null;
            }
            if ("true".equalsIgnoreCase(value)) {
                return true;
            }
            if ("false".equalsIgnoreCase(value)) {
                return false;
            }
            if (value.charAt(0) == '-' || value.charAt(0) >= '0' && value.charAt(0) <= '9') {
                try {
                    int int_value = Integer.parseInt(value);
                    if ((int_value + "").equals(value)) {
                        return int_value;
                    }
                }
                catch (NumberFormatException e) {
                    try {
                        long long_value = Long.parseLong(value);
                        if ((long_value + "").equals(value)) {
                            return long_value;
                        }
                    }
                    catch (NumberFormatException e1) {
                        if (!value.matches("[0-9]{1,13}(\\.[0-9]*)?")) break block12;
                        return Double.parseDouble(value);
                    }
                }
            }
        }
        return value;
    }

    public static boolean toBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value.equals(true) || value.equals(1)) {
            return true;
        }
        if (value instanceof String) {
            String _value = (String)value;
            if (_value.equalsIgnoreCase("yes") || _value.equalsIgnoreCase("true") || _value.equals("1") || _value.equalsIgnoreCase("on")) {
                return true;
            }
            if (_value.equalsIgnoreCase("no") || _value.equalsIgnoreCase("false") || _value.equals("0") || _value.equalsIgnoreCase("off") || _value.equalsIgnoreCase("null")) {
                return false;
            }
        }
        return false;
    }

    public static Object objectCast(Object value, Class<?> t) {
        if (value == null) {
            return null;
        }
        if (t == Boolean.TYPE || t == Boolean.class) {
            value = MappingValue.toBoolean(value);
        } else if (t == Integer.TYPE || t == Integer.class) {
            value = CommonUtil.isEmptyString(value.toString()) ? 0 : Integer.parseInt(value.toString());
        } else if (t == int[].class || t == Integer[].class) {
            if (value instanceof String) {
                value = MappingValue.stringArr2intArr((String)value, ",");
            } else if (value instanceof List) {
                value = MappingValue.intList2Arr((List)value);
            }
        } else if (t == Long.TYPE || t == Long.class) {
            value = Long.valueOf(value == null || CommonUtil.isEmptyString(value.toString()) ? "0" : value.toString());
        } else if (t == String.class) {
            value = value.toString();
        } else if (t == String[].class) {
            if (value instanceof ArrayList) {
                ArrayList list = (ArrayList)value;
                value = list.toArray(new String[list.size()]);
            } else if (value instanceof String) {
                String str = (String)value;
                value = str.split(",");
            }
        } else if (t == Date.class) {
            value = CommonUtil.Objet2Date(value);
        } else if (t == BigDecimal.class) {
            if (value instanceof Integer) {
                value = new BigDecimal((Integer)value);
            } else if (value instanceof String) {
                BigDecimal b = new BigDecimal((String)value);
                b.setScale(2, 1);
                value = b;
            } else if (value instanceof Double) {
                value = new BigDecimal(Double.toString((Double)value));
            }
        }
        return value;
    }

    private static int[] intList2Arr(List<Integer> list) {
        return MappingValue.newIntArray(list.size(), index -> (Integer)list.get((int)index));
    }

    private static int[] stringArr2intArr(String value, String diver) {
        String[] strArr = value.split(diver);
        return MappingValue.newIntArray(strArr.length, index -> Integer.parseInt(strArr[index].trim()));
    }

    private static int[] newIntArray(int length, Function<Integer, Integer> fn) {
        int[] arr = new int[length];
        for (int i = 0; i < length; ++i) {
            arr[i] = fn.apply(i);
        }
        return arr;
    }
}

