/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util;

import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.logger.LogHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ReflectUtil {
    private static final LogHelper LOGGER = LogHelper.getLog(ReflectUtil.class);

    public static <T> T newInstance(Class<T> clz, Object ... args) {
        if (clz.isInterface()) {
            LOGGER.warning("\u6240\u4f20\u9012\u7684class\u7c7b\u578b\u53c2\u6570\u4e3a\u63a5\u53e3\uff0c\u65e0\u6cd5\u5b9e\u4f8b\u5316");
            return null;
        }
        if (args == null || args.length == 0) {
            try {
                return clz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.warning(e);
            }
        }
        Constructor<T> constructor = ReflectUtil.getConstructor(clz, ReflectUtil.args2class(args));
        return ReflectUtil.newInstance(constructor, args);
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            LOGGER.warning(e, "\u5b9e\u4f8b\u5316\u5bf9\u8c61\u5931\u8d25\uff1a" + constructor.getDeclaringClass());
            return null;
        }
    }

    public static boolean hasArgsCon(Class<?> clz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clz.getConstructors()) {
            if (constructor.getParameterTypes().length == 0) continue;
            return true;
        }
        return false;
    }

    public static Object newInstance(String clzName, Object ... args) {
        Class<?> clazz = ReflectUtil.getClassByName(clzName);
        return clazz != null ? ReflectUtil.newInstance(clazz, args) : null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clz, Class<?> ... argClz) {
        try {
            return argClz != null ? clz.getConstructor(argClz) : clz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOGGER.warning(e, "\u627e\u4e0d\u5230\u8fd9\u4e2a {0} \u7c7b\u7684\u6784\u9020\u5668\u3002", clz.getName());
        }
        catch (SecurityException e) {
            LOGGER.warning(e);
        }
        return null;
    }

    public static Class<?> getClassByName(String clzName) {
        try {
            return Class.forName(clzName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning(e, "\u627e\u4e0d\u5230\u8fd9\u4e2a\u7c7b\uff1a{0}\u3002", clzName);
            return null;
        }
    }

    public static <T> Class<T> getClassByName(String clzName, Class<T> clz) {
        Class<?> c = ReflectUtil.getClassByName(clzName);
        return c == null ? null : ReflectUtil.getClassByName(clzName);
    }

    public static Class<?>[] args2class(Object[] args) {
        Class[] clazzes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            clazzes[i] = args[i].getClass();
        }
        return clazzes;
    }

    public static Class<?> getClassByInterface(Type type) {
        String className = type.toString();
        className = className.replaceAll("<.*>$", "").replaceAll("(class|interface)\\s", "");
        return ReflectUtil.getClassByName(className);
    }

    public static Class<?>[] getDeclaredInterface(Class<?> clz) {
        ArrayList fields = new ArrayList();
        while (clz != Object.class) {
            Class<?>[] currentInterfaces = clz.getInterfaces();
            fields.addAll(Arrays.asList(currentInterfaces));
            clz = clz.getSuperclass();
        }
        return fields.toArray(new Class[fields.size()]);
    }

    public static Method getMethod(Object obj, String method, Class<?> ... args) {
        Class<?> cls = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        try {
            return CommonUtil.isNull(args) ? cls.getMethod(method, new Class[0]) : cls.getMethod(method, args);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String str = "";
            for (Class<?> clz : args) {
                str = str + clz.getName();
            }
            LOGGER.warning("\u7c7b\u627e\u4e0d\u5230\u8fd9\u4e2a\u65b9\u6cd5 {0}.{1}({2})\u3002", cls.getName(), method, str.equals("") ? "void" : str);
            return null;
        }
    }

    public static Method getMethod(Object obj, String method, Object ... args) {
        if (!CommonUtil.isNull(args)) {
            return ReflectUtil.getMethod(obj, method, ReflectUtil.args2class(args));
        }
        return ReflectUtil.getMethod(obj, method, new Class[0]);
    }

    public static Method getMethodByUpCastingSearch(Class<?> clz, String method, Object arg) {
        for (Class<?> clazz = arg.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                return clz.getMethod(method, clazz);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                continue;
            }
        }
        return null;
    }

    public static Method getDeclaredMethodByInterface(Class<?> clz, String method, Object arg) {
        Method methodObj = null;
        for (Class<?> clazz = arg.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Type[] intfs = clazz.getGenericInterfaces();
            if (intfs.length == 0) continue;
            try {
                for (Type intf : intfs) {
                    methodObj = ReflectUtil.getSuperClassDeclaredMethod(clz, method, ReflectUtil.getClassByInterface(intf));
                    if (methodObj == null) continue;
                    return methodObj;
                }
                continue;
            }
            catch (Exception e) {
                LOGGER.warning(e);
            }
        }
        return null;
    }

    public static Method getSuperClassDeclaredMethod(Class<?> clz, String method, Class<?> argClz) {
        while (clz != Object.class) {
            try {
                return clz.getDeclaredMethod(method, argClz);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                clz = clz.getSuperclass();
            }
        }
        return null;
    }

    public static Method getSuperClassDeclaredMethod(Class<?> clz, String method) {
        while (clz != Object.class) {
            for (Method m : clz.getDeclaredMethods()) {
                if (!m.toString().contains(method)) continue;
                return m;
            }
            clz = clz.getSuperclass();
        }
        return null;
    }

    public static Object executeMethod_Throwable(Object instance, Method method, Object ... args) throws Throwable {
        if (instance == null || method == null) {
            return null;
        }
        try {
            return args == null || args.length == 0 ? method.invoke(instance, new Object[0]) : method.invoke(instance, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
            if (e1 instanceof InvocationTargetException) {
                Throwable e = ((InvocationTargetException)e1).getTargetException();
                LOGGER.warning("\u53cd\u5c04\u6267\u884c\u65b9\u6cd5\u5f02\u5e38\uff01\u6240\u5728\u7c7b[{0}] \u65b9\u6cd5\uff1a[{1}]", instance.getClass().getName(), method.getName());
                throw e;
            }
            throw e1;
        }
    }

    public static Throwable getUnderLayerErr(Throwable e) {
        while (e.getClass().equals(InvocationTargetException.class) || e.getClass().equals(UndeclaredThrowableException.class)) {
            e = e.getCause();
        }
        return e;
    }

    public static String getUnderLayerErrMsg(Throwable e) {
        String msg = ReflectUtil.getUnderLayerErr(e).toString();
        return msg.replaceAll("^[^:]*:\\s?", "");
    }

    public static Object executeMethod(Object instance, Method method, Object ... args) {
        try {
            return ReflectUtil.executeMethod_Throwable(instance, method, args);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Object executeMethod(Object instnace, String method, Object ... args) {
        Class<?>[] clazzes = ReflectUtil.args2class(args);
        Method methodObj = ReflectUtil.getMethod(instnace.getClass(), method, clazzes);
        return methodObj != null ? ReflectUtil.executeMethod(instnace, methodObj, args) : null;
    }

    public static Object executeMethod(Object instnace, String method, Class<?> argType, Object argValue) {
        Method m = ReflectUtil.getMethod(instnace, method, argType);
        if (m != null) {
            return ReflectUtil.executeMethod(instnace, m, argValue);
        }
        return null;
    }

    public static Object executeStaticMethod(Method method, Object ... args) {
        if (ReflectUtil.isStaticMethod(method)) {
            try {
                return ReflectUtil.executeMethod_Throwable(new Object(), method, args);
            }
            catch (Throwable e) {
                LOGGER.warning(e);
            }
        } else {
            LOGGER.warning("\u8fd9\u4e0d\u662f\u4e00\u4e2a\u9759\u6001\u65b9\u6cd5\uff1a" + method);
        }
        return null;
    }

    public static boolean isStaticMethod(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static String firstLetterUpper(String str) {
        return Character.toString(str.charAt(0)).toUpperCase() + str.substring(1);
    }

    public static String getFieldName(String method, String action) {
        method = method.replace(action, "");
        return Character.toString(method.charAt(0)).toLowerCase() + method.substring(1);
    }

    public static void setProperty(Object bean, String name, Object value) {
        String setMethodName = "set" + ReflectUtil.firstLetterUpper(name);
        Objects.requireNonNull(bean, bean + "\u6267\u884c\uff1a" + setMethodName + " \u672a\u53d1\u73b0\u7c7b");
        Class<?> clazz = bean.getClass();
        Method method = ReflectUtil.getMethodByUpCastingSearch(clazz, setMethodName, value);
        if (method == null) {
            method = ReflectUtil.getDeclaredMethodByInterface(clazz, setMethodName, value);
        }
        if (method == null) {
            method = ReflectUtil.getSuperClassDeclaredMethod(clazz, setMethodName);
        }
        Objects.requireNonNull(method, "\u627e\u4e0d\u5230\u76ee\u6807\u65b9\u6cd5[" + clazz.getSimpleName() + "." + setMethodName + "(" + value.getClass().getSimpleName() + ")]");
        ReflectUtil.executeMethod(bean, method, value);
    }

    public static Map<String, Integer> getConstantsInt(Class<?> clz) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Field[] fields = clz.getDeclaredFields();
        Object instance = ReflectUtil.newInstance(clz, new Object[0]);
        for (Field field : fields) {
            String descriptor = Modifier.toString(field.getModifiers());
            if (!descriptor.equals("public static final")) continue;
            try {
                map.put(field.getName(), (int)((Integer)field.get(instance)));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.warning(e);
            }
        }
        return map;
    }
}

