/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util;

import com.ajaxjs.util.logger.LogHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlHelper {
    private static final LogHelper LOGGER = LogHelper.getLog(XmlHelper.class);

    public static DocumentBuilderFactory initBuilderFactory() {
        return DocumentBuilderFactory.newInstance();
    }

    public static DocumentBuilder initBuilder() {
        try {
            return XmlHelper.initBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static void xPath(String xml, String xpath, Consumer<Node> fn) {
        DocumentBuilderFactory factory = XmlHelper.initBuilderFactory();
        factory.setNamespaceAware(true);
        try {
            XPathExpression expr = XPathFactory.newInstance().newXPath().compile(xpath);
            NodeList nodes = (NodeList)expr.evaluate(factory.newDocumentBuilder().parse(xml), XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                fn.accept(nodes.item(i));
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            LOGGER.warning(e);
        }
    }

    public static void parseXML(String xml, BiConsumer<Element, NodeList> fn) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));){
            Element el = XmlHelper.initBuilder().parse(in).getDocumentElement();
            NodeList nodeList = el.getChildNodes();
            fn.accept(el, nodeList);
        }
        catch (IOException | SAXException e) {
            LOGGER.warning(e);
        }
    }

    public static Map<String, String> nodeAsMap(String xml, String xpath) {
        HashMap<String, String> map = new HashMap<String, String>();
        XmlHelper.xPath(xml, xpath, node -> {
            NamedNodeMap _map = node.getAttributes();
            if (_map != null) {
                int n = _map.getLength();
                for (int i = 0; i < n; ++i) {
                    Node _node = _map.item(i);
                    map.put(_node.getNodeName(), _node.getNodeValue());
                }
            }
        });
        if (map.size() == 0) {
            return null;
        }
        return map;
    }
}

