/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util.cache;

import com.ajaxjs.util.cache.ExpireCacheData;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class ExpireCache
extends ConcurrentHashMap<String, ExpireCacheData<Object>> {
    private static final long serialVersionUID = 3850668473354271847L;
    public static final ExpireCache CACHE = new ExpireCache();

    public Object get(String key) {
        ExpireCacheData data = (ExpireCacheData)super.get(key);
        long now = new Date().getTime();
        if (data != null && (data.expire <= 0L || data.saveTime >= now)) {
            return data.data;
        }
        if (data != null && data.load != null) {
            Object value = data.load.get();
            data.data = value;
            data.saveTime = now + data.expire;
            return value;
        }
        return null;
    }

    public <T> T get(String key, Class<T> clz) {
        Object obj = this.get(key);
        return (T)(obj == null ? null : obj);
    }

    public void put(String key, Object data, int expire) {
        this.put(key, new ExpireCacheData<Object>(data, expire));
    }

    public void put(String key, Object data, int expire, Supplier<Object> load) {
        this.put(key, new ExpireCacheData<Object>(data, expire, load));
    }

    static {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                for (String key : CACHE.keySet()) {
                    Object obj = CACHE.get(key);
                    if (obj != null) continue;
                    CACHE.remove(key);
                }
            }
        }, 0L, 10000L);
    }
}

