/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util.cryptography;

import com.ajaxjs.util.logger.LogHelper;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class CipherInfo {
    private static final LogHelper LOGGER = LogHelper.getLog(CipherInfo.class);
    private String cipherAlgorithm;
    private int keySize;

    public CipherInfo(String cipherAlgorithm, int keySize) {
        this.cipherAlgorithm = cipherAlgorithm;
        this.keySize = keySize;
    }

    static byte[] doCipher(String algorithm, int mode, Key key, byte[] s) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(mode, key);
            return cipher.doFinal(s);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    static byte[] doCipher(CipherInfo ci, int mode, String key, byte[] bytes) {
        SecretKey _key;
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            sr.setSeed(key.getBytes());
            KeyGenerator kg = KeyGenerator.getInstance(ci.getCipherAlgorithm());
            kg.init(ci.getKeySize(), sr);
            _key = kg.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.warning(e);
            return null;
        }
        return CipherInfo.doCipher(ci.getCipherAlgorithm(), mode, _key, bytes);
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }
}

