/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util.cryptography;

import com.ajaxjs.util.cryptography.CipherInfo;
import com.ajaxjs.util.logger.LogHelper;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

public class RSA_Cipher {
    private static final LogHelper LOGGER = LogHelper.getLog(RSA_Cipher.class);
    private static final CipherInfo CI = new CipherInfo("RSA/ECB/PKCS1Padding", 2048);
    public static final String PUBLIC_KEY = "publicKey";
    public static final String PRIVATE_KEY = "privateKey";

    private static byte[] action(int mode, Key key, byte[] s) {
        return CipherInfo.doCipher(CI.getCipherAlgorithm(), mode, key, s);
    }

    public static Map<String, byte[]> generatePair() {
        KeyPairGenerator g;
        try {
            g = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.warning(e);
            return null;
        }
        g.initialize(CI.getKeySize());
        KeyPair kp = g.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)kp.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)kp.getPrivate();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put(PUBLIC_KEY, publicKey.getEncoded());
        map.put(PRIVATE_KEY, privateKey.getEncoded());
        return map;
    }

    public static PublicKey restorePublicKey(byte[] key) {
        X509EncodedKeySpec ks = new X509EncodedKeySpec(key);
        try {
            return KeyFactory.getInstance("RSA").generatePublic(ks);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static PrivateKey restorePrivateKey(byte[] key) {
        PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(key);
        try {
            return KeyFactory.getInstance("RSA").generatePrivate(ks);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static byte[] encrypt(PublicKey key, byte[] text) {
        return RSA_Cipher.action(1, key, text);
    }

    public static String decrypt(PrivateKey key, byte[] encoded) {
        return new String(RSA_Cipher.action(2, key, encoded));
    }
}

