/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util.cryptography;

import com.ajaxjs.util.Encode;
import com.ajaxjs.util.cryptography.CipherInfo;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SymmetriCipher {
    private static final CipherInfo AES = new CipherInfo("AES", 128);
    private static final CipherInfo DES = new CipherInfo("DES", 56);

    public static String AES_Encrypt(String str, String key) {
        return Encode.base64Encode(CipherInfo.doCipher(AES, 1, key, str.getBytes(StandardCharsets.UTF_8)));
    }

    public static String AES_Decrypt(String str, String key) {
        byte[] b = CipherInfo.doCipher(AES, 2, key, Encode.base64DecodeAsByte(str));
        if (b == null || b.length == 0) {
            return null;
        }
        return Encode.byte2String(b);
    }

    public static String DES_Encrypt(String str, String key) {
        return Encode.base64Encode(CipherInfo.doCipher(DES, 1, key, str.getBytes(StandardCharsets.UTF_8)));
    }

    public static String DES_Decrypt(String str, String key) {
        return Encode.byte2String(CipherInfo.doCipher(DES, 2, key, Encode.base64DecodeAsByte(str)));
    }

    public static byte[] HMACSHA256(String data, String key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256"));
            return mac.doFinal(data.getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

