/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util.io;

import com.ajaxjs.Version;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.io.StreamHelper;
import com.ajaxjs.util.logger.LogHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class FileHelper
extends StreamHelper {
    private static final LogHelper LOGGER = LogHelper.getLog(FileHelper.class);
    public static final String SEPARATOR = File.separator;

    public static boolean copy(String target, String dest, boolean isReplace) {
        try {
            if (isReplace) {
                Files.copy(Paths.get(target, new String[0]), Paths.get(dest, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(Paths.get(target, new String[0]), Paths.get(dest, new String[0]), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            LOGGER.warning(e);
            return false;
        }
        return true;
    }

    public static boolean move(String target, String dest) {
        try {
            Files.copy(Paths.get(target, new String[0]), Paths.get(dest, new String[0]), new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.warning(e);
            return false;
        }
        return true;
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                FileHelper.delete(f);
            }
        }
        if (!file.delete()) {
            LOGGER.warning("\u6587\u4ef6 {0} \u5220\u9664\u5931\u8d25\uff01", file.toString());
        }
    }

    public static void delete(String filePath) {
        FileHelper.delete(new File(filePath));
    }

    public static String openAsText(String filePath, Charset encode) {
        LOGGER.info("\u8bfb\u53d6\u6587\u4ef6[{0}]", filePath);
        Path path = Paths.get(filePath, new String[0]);
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                throw new IOException("\u53c2\u6570 fullpath\uff1a" + filePath + " \u4e0d\u80fd\u662f\u76ee\u5f55\uff0c\u8bf7\u6307\u5b9a\u6587\u4ef6");
            }
        }
        catch (IOException e) {
            LOGGER.warning(e);
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder();
            Files.lines(path, encode).forEach(str -> sb.append((String)str));
            return sb.toString();
        }
        catch (IOException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static String openAsText(String filePath) {
        return FileHelper.openAsText(filePath, StandardCharsets.UTF_8);
    }

    public static byte[] openAsByte(File file) {
        try {
            return FileHelper.inputStream2Byte(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static void save(File file, byte[] data, boolean isOverwrite) {
        LOGGER.info("\u6b63\u5728\u4fdd\u5b58\u6587\u4ef6" + file);
        try {
            if (!isOverwrite && file.exists()) {
                throw new IOException(file + "\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u7981\u6b62\u8986\u76d6\uff01");
            }
            if (file.isDirectory()) {
                throw new IOException(file + " \u4e0d\u80fd\u662f\u76ee\u5f55\uff0c\u8bf7\u6307\u5b9a\u6587\u4ef6");
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            Files.write(file.toPath(), data, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
    }

    public static void save(File file, byte[] data, int off, int len) {
        try (FileOutputStream out = new FileOutputStream(file);){
            FileHelper.bytes2output(out, data, false, off, len);
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
    }

    public static void saveText(File file, String text) {
        if (Version.isDebug) {
            String _text = text.length() > 200 ? text.substring(0, 200) + "..." : text;
            LOGGER.info("\u6b63\u5728\u4fdd\u5b58\u6587\u4ef6{0}\uff0c \u4fdd\u5b58\u5185\u5bb9\uff1a\n{1}", file.toString(), _text);
        } else {
            LOGGER.info("\u6b63\u5728\u4fdd\u5b58\u6587\u4ef6{0}\uff0c \u4fdd\u5b58\u5185\u5bb9\uff1a\n{1}", file.toString());
        }
        FileHelper.save(file, text.getBytes(StandardCharsets.UTF_8), true);
    }

    public static void saveText(String filePath, String text) {
        FileHelper.saveText(new File(filePath), text);
    }

    public static void mkDir(String folder) {
        File _folder = new File(folder);
        if (!_folder.exists()) {
            _folder.mkdirs();
        }
        _folder.mkdir();
    }

    public static void mkDirByFileName(String filePath) {
        CharSequence[] arr = filePath.split("\\/|\\\\");
        arr[arr.length - 1] = "";
        String folder = String.join((CharSequence)SEPARATOR, arr);
        FileHelper.mkDir(folder);
    }

    public static void initFolder(File file) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u662f\u6587\u4ef6\uff0c\u4e0d\u662f\u76ee\u5f55");
        }
        FileHelper.mkDir(file.getParent());
    }

    public static void initFolder(String file) {
        FileHelper.initFolder(new File(file));
    }

    public static File createFile(String folder, String fileName) {
        LOGGER.info("\u6b63\u5728\u65b0\u5efa\u6587\u4ef6 {0}", folder + SEPARATOR + fileName);
        FileHelper.mkDir(folder);
        return new File(folder + SEPARATOR + fileName);
    }

    public static File createFile(String filePath, boolean isOverwrite) throws IOException {
        LOGGER.info("\u6b63\u5728\u65b0\u5efa\u6587\u4ef6 {0}", filePath);
        FileHelper.mkDirByFileName(filePath);
        File file = new File(filePath);
        if (!isOverwrite && file.exists()) {
            throw new IOException("\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u7981\u6b62\u8986\u76d6\uff01");
        }
        return file;
    }

    public static String getDirNameByDate() {
        String datatime = CommonUtil.now("yyyy-MM-dd");
        String year = datatime.substring(0, 4);
        String mouth = datatime.substring(5, 7);
        String day = datatime.substring(8, 10);
        return SEPARATOR + year + SEPARATOR + mouth + SEPARATOR + day + SEPARATOR;
    }

    public static String getFileName(String str) {
        String[] arr = str.split("\\/|\\\\");
        return arr[arr.length - 1];
    }

    public static String getFileNameFromUrl(String url) {
        return FileHelper.getFileName(url).split("\\?")[0];
    }

    public static String getFileSuffix(String filename) {
        return filename.substring(filename.lastIndexOf(".") + 1);
    }
}

