/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util.io;

import com.ajaxjs.util.logger.LogHelper;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StreamHelper {
    private static final LogHelper LOGGER = LogHelper.getLog(StreamHelper.class);
    public static final int BUFFER_SIZE = 1024;

    public static String byteStream2string(InputStream in) {
        return StreamHelper.byteStream2string_Charset(in, StandardCharsets.UTF_8);
    }

    public static String byteStream2string_Charset(InputStream in, Charset encode) {
        StringBuilder result = new StringBuilder();
        try (InputStreamReader inReader = new InputStreamReader(in, encode);
             BufferedReader reader = new BufferedReader(inReader);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append('\n');
            }
            inReader.close();
        }
        catch (IOException e) {
            LOGGER.warning(e);
            return null;
        }
        return result.toString();
    }

    public static void write(InputStream in, OutputStream out, boolean isBuffer) {
        block17: {
            byte[] buffer = new byte[1024];
            try {
                int readSize;
                if (isBuffer) {
                    try (BufferedOutputStream _out = new BufferedOutputStream(out);){
                        int readSize2;
                        while ((readSize2 = in.read(buffer)) != -1) {
                            ((OutputStream)_out).write(buffer, 0, readSize2);
                        }
                        break block17;
                    }
                }
                while ((readSize = in.read(buffer, 0, 1024)) != -1) {
                    out.write(buffer, 0, readSize);
                }
                out.flush();
            }
            catch (IOException e) {
                LOGGER.warning(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] inputStream2Byte(InputStream in) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            StreamHelper.write(in, out, true);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            LOGGER.warning(e);
            return null;
        }
    }

    public static void bytes2output(OutputStream out, byte[] data, int off, int length) {
        StreamHelper.bytes2output(out, data, true, off, length);
    }

    public static void bytes2output(OutputStream out, byte[] data, boolean isBuffered, int off, int length) {
        try {
            if (isBuffered) {
                out = new BufferedOutputStream(out, 1024);
            }
            if (off == 0 && length == 0) {
                out.write(data);
            } else {
                out.write(data, off, length);
            }
            out.flush();
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
    }

    public static byte[] subBytes(byte[] data, int off, int length) {
        byte[] bs = new byte[length];
        System.arraycopy(data, off, bs, 0, length);
        return bs;
    }

    public static int byteIndexOf(byte[] data, byte[] search, int start) {
        int len = search.length;
        for (int i = start; i < data.length; ++i) {
            int temp = i;
            int j = 0;
            while (data[temp] == search[j]) {
                ++temp;
                if (++j != len) continue;
                return i;
            }
        }
        return -1;
    }

    public static int byteIndexOf(byte[] data, byte[] search) {
        return StreamHelper.byteIndexOf(data, search, 0);
    }

    public static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }
}

