/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util.io;

import com.ajaxjs.util.io.FileHelper;
import com.ajaxjs.util.io.StreamHelper;
import com.ajaxjs.util.logger.LogHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
    private static final LogHelper LOGGER = LogHelper.getLog(ZipHelper.class);

    public static void unzip(String save, String zipFile) {
        if (!new File(save).isDirectory()) {
            throw new IllegalArgumentException("\u4fdd\u5b58\u7684\u8def\u5f84\u5fc5\u987b\u4e3a\u76ee\u5f55\u8def\u5f84");
        }
        long start = System.currentTimeMillis();
        File folder = new File(save);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                File newFile = new File(save + File.separator + ze.getName());
                if (ze.isDirectory()) {
                    newFile.mkdirs();
                    continue;
                }
                FileHelper.initFolder(newFile);
                FileOutputStream fos = new FileOutputStream(newFile);
                StreamHelper.write(zis, fos, false);
                fos.close();
            }
            zis.closeEntry();
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
        LOGGER.info("\u89e3\u538b\u7f29\u5b8c\u6210\uff0c\u8017\u65f6\uff1a{0}ms\uff0c\u4fdd\u5b58\u5728{1}", System.currentTimeMillis() - start, save);
    }

    public static void zip(String toZip, String saveZip) {
        ZipHelper.zip(toZip, saveZip, null);
    }

    public static void zip(String toZip, String saveZip, Function<File, Boolean> everyFile) {
        long start = System.currentTimeMillis();
        File fileToZip = new File(toZip);
        FileHelper.initFolder(saveZip);
        try (FileOutputStream fos = new FileOutputStream(saveZip);
             ZipOutputStream zipOut = new ZipOutputStream(fos);){
            ZipHelper.zip(fileToZip, fileToZip.getName(), zipOut, everyFile);
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
        LOGGER.info("\u538b\u7f29\u5b8c\u6210\uff0c\u8017\u65f6\uff1a{0}ms\uff0c\u4fdd\u5b58\u5728{1}", System.currentTimeMillis() - start, saveZip);
    }

    private static void zip(File toZip, String fileName, ZipOutputStream zipOut, Function<File, Boolean> everyFile) {
        if (toZip.isHidden()) {
            return;
        }
        if (everyFile != null && !everyFile.apply(toZip).booleanValue()) {
            return;
        }
        try {
            if (toZip.isDirectory()) {
                File[] children;
                zipOut.putNextEntry(new ZipEntry(fileName.endsWith("/") ? fileName : fileName + "/"));
                zipOut.closeEntry();
                for (File childFile : children = toZip.listFiles()) {
                    ZipHelper.zip(childFile, fileName + "/" + childFile.getName(), zipOut, everyFile);
                }
                return;
            }
            zipOut.putNextEntry(new ZipEntry(fileName));
            try (FileInputStream in = new FileInputStream(toZip);){
                StreamHelper.write(in, zipOut, false);
            }
        }
        catch (IOException e) {
            LOGGER.warning(e);
        }
    }
}

