/*
 * Decompiled with CFR 0.152.
 */
package com.ajaxjs.util.ioc;

import com.ajaxjs.framework.GetConfig;
import com.ajaxjs.framework.IComponent;
import com.ajaxjs.util.CommonUtil;
import com.ajaxjs.util.ReflectUtil;
import com.ajaxjs.util.ioc.Component;
import com.ajaxjs.util.ioc.ComponentInfo;
import com.ajaxjs.util.ioc.EveryClass;
import com.ajaxjs.util.ioc.Resource;
import com.ajaxjs.util.logger.LogHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;

public class ComponentMgr {
    private static final LogHelper LOGGER = LogHelper.getLog(ComponentMgr.class);
    public static Map<String, ComponentInfo> components = new HashMap<String, ComponentInfo>();
    public static Set<Class<?>> clzs = new LinkedHashSet();

    public static void scan(String ... packageNames) {
        for (String packageName : packageNames) {
            ComponentMgr.scan(packageName);
        }
    }

    public static void scan(String packageName) {
        LOGGER.debug("\u626b\u63cf[{0}]\u5305\u4e0b\u9762\u6240\u6709\u7684\u7c7b", packageName);
        LinkedHashSet clzs = new LinkedHashSet();
        new EveryClass().scan(packageName, resource -> {
            ClassPool cp = ClassPool.getDefault();
            try {
                CtField[] fields;
                CtClass cc = cp.get(resource);
                for (CtField field : fields = cc.getDeclaredFields()) {
                    CtMethod setter;
                    if (field.getAnnotation(Resource.class) == null) continue;
                    String setMethodName = "set" + ReflectUtil.firstLetterUpper(field.getName());
                    try {
                        setter = cc.getDeclaredMethod(setMethodName, new CtClass[]{field.getType()});
                    }
                    catch (NotFoundException e) {
                        CtField f1 = new CtField(field.getType(), field.getName(), cc);
                        setter = CtNewMethod.setter((String)setMethodName, (CtField)f1);
                        cc.addMethod(setter);
                    }
                }
                Class clz = cc.toClass();
                if (!(clz.isPrimitive() || Modifier.isAbstract(clz.getModifiers()) || clz.isAnnotation() || clz.isInterface() || clz.isArray() || clz.getName().indexOf("$") != -1)) {
                    if (IComponent.class.isAssignableFrom(clz)) {
                        ReflectUtil.getClassByName(clz.getCanonicalName());
                    }
                    clzs.add(clz);
                }
            }
            catch (CannotCompileException e) {
                Class<?> clazz = ReflectUtil.getClassByName(resource);
                clzs.add(clazz);
            }
            catch (ClassNotFoundException | NotFoundException e) {
                LOGGER.warning(e);
            }
        });
        ComponentMgr.clzs.addAll(clzs);
    }

    public static void inject() {
        HashMap<String, String> dependencies = new HashMap<String, String>();
        for (Class<?> clz : clzs) {
            Component annotation = clz.getAnnotation(Component.class);
            if (annotation == null) continue;
            String alias = annotation.value();
            if (CommonUtil.isEmptyString(alias)) {
                alias = clz.getSimpleName();
            }
            if (components.containsKey(alias)) {
                LOGGER.warning("\u76f8\u540c\u7684 \u7ec4\u4ef6\u540d\u79f0\uff08Alias\uff09[{0}] \u5df2\u7ecf\u5b58\u5728", alias);
            }
            ComponentMgr.register(alias, clz, true);
            for (Class<?> superClz = clz; superClz != Object.class; superClz = superClz.getSuperclass()) {
                for (Field field : superClz.getDeclaredFields()) {
                    Resource res = field.getAnnotation(Resource.class);
                    if (res == null) continue;
                    String dependenciObj_id = ComponentMgr.parseId(res, field);
                    dependencies.put(alias + "." + field.getName(), dependenciObj_id);
                }
            }
        }
        dependencies.forEach((k, v) -> {
            String[] split = k.split("\\.");
            Object bean = ComponentMgr.get(split[0]);
            Object argBean = ComponentMgr.get(v);
            Objects.requireNonNull(bean, split[0] + "\u6267\u884c[" + split[1] + "]\u672a\u53d1\u73b0\u7c7b");
            if (argBean == null) {
                LOGGER.warning("\u5bb9\u5668\u4e2d\u627e\u4e0d\u5230\u5b9e\u4f8b[{0}]\u3002\u8bf7\u786e\u5b9a\u662f\u5426\u4e3a\u7ec4\u4ef6\u6dfb\u52a0 @Component \u6ce8\u89e3?", v);
            } else {
                ReflectUtil.setProperty(bean, split[1], argBean);
            }
        });
    }

    private static String parseId(Resource res, Field field) {
        String resource = res.value();
        if (resource.startsWith("autoWire:") && ReflectUtil.getClassByName("com.ajaxjs.framework.config.ConfigService") != null) {
            String target;
            String extendedId;
            GetConfig cfg = ComponentMgr.getByInterface(GetConfig.class);
            if (cfg == null) {
                ComponentMgr.register("ConfigService", ReflectUtil.getClassByName("com.ajaxjs.framework.config.ConfigService"), true);
                cfg = ComponentMgr.getByInterface(GetConfig.class);
            }
            return (extendedId = cfg.getString(target = resource.replaceFirst("autoWire:", ""))) == null ? field.getType().getSimpleName() : extendedId;
        }
        if (CommonUtil.isEmptyString(resource)) {
            resource = field.getType().getSimpleName();
        }
        return resource;
    }

    public static <T> T get(Class<T> clz) {
        if (clz.isInterface()) {
            return ComponentMgr.getByInterface(clz);
        }
        ComponentInfo compInfo = null;
        for (String alias : components.keySet()) {
            ComponentInfo _compInfo = components.get(alias);
            if (clz != _compInfo.clazz && (_compInfo.instance == null || !clz.isInstance(_compInfo.instance))) continue;
            compInfo = _compInfo;
        }
        return ComponentMgr.getInstance(compInfo, clz, clz);
    }

    public static <T> List<T> getAll(Class<T> clz) {
        if (clz.isInterface()) {
            return ComponentMgr.getAllByInterface(clz);
        }
        ArrayList list = new ArrayList();
        components.forEach((alias, compInfo) -> {
            if (clz == compInfo.clazz || compInfo.instance != null && clz.isInstance(compInfo.instance)) {
                list.add(compInfo.instance);
            }
        });
        return list;
    }

    public static Object get(String aliasOrClz) {
        return ComponentMgr.get(aliasOrClz, Object.class);
    }

    public static <T> T get(String aliasOrClz, Class<T> clz) {
        if (aliasOrClz.contains(".")) {
            for (String alias : components.keySet()) {
                ComponentInfo compInfo = components.get(alias);
                if (!aliasOrClz.equals(compInfo.namespace)) continue;
                return ComponentMgr.getInstance(compInfo, clz, aliasOrClz);
            }
        } else {
            ComponentInfo compInfo = components.get(aliasOrClz);
            return ComponentMgr.getInstance(compInfo, clz, aliasOrClz);
        }
        return null;
    }

    private static <T> T getInstance(ComponentInfo compInfo, Class<T> clz, Object info) {
        Objects.requireNonNull(compInfo, "\u627e\u4e0d\u5230[" + info + "]\u76ee\u6807\u7ec4\u4ef6");
        if (compInfo.instance == null) {
            return (T)ReflectUtil.newInstance(compInfo.clazz, new Object[0]);
        }
        return (T)compInfo.instance;
    }

    public static <T> T getByInterface(Class<T> interfaceClz) {
        for (String alias : components.keySet()) {
            Object instance = ComponentMgr.components.get((Object)alias).instance;
            if (instance == null || !interfaceClz.isAssignableFrom(instance.getClass())) continue;
            return (T)instance;
        }
        return null;
    }

    public static <T> List<T> getAllByInterface(Class<T> interfaceClz) {
        ArrayList list = new ArrayList();
        components.forEach((alias, compInfo) -> {
            Object instance = ComponentMgr.components.get((Object)alias).instance;
            if (instance != null && interfaceClz.isAssignableFrom(instance.getClass())) {
                list.add(instance);
            }
        });
        return list;
    }

    public static void register(String alias, Class<?> clz, boolean isSingleton) {
        ComponentInfo compInfo = new ComponentInfo();
        compInfo.clazz = clz;
        compInfo.namespace = clz.getCanonicalName();
        if (isSingleton) {
            compInfo.instance = ReflectUtil.newInstance(clz, new Object[0]);
        }
        if (alias == null) {
            alias = clz.getCanonicalName();
        }
        components.put(alias, compInfo);
    }
}

